require 'rubygems'
require 'rspec'
require 'watir-webdriver'

require_relative '../module/DriverUtility'
require_relative './rspec_helper'
require_relative '../pages/landing'
require_relative '../pages/login'
require_relative '../common/common'
require_relative '../pages/manage_settings'
require_relative '../module/DateUtility'

describe '[Story VARUT-16: Utility - Authentication]
          [Story VARUT-17: Utility - Authenticated & Authorized Landing page]
          [Story VARUT-12: Utility - Authorization]' do
  include DriverUtility
  include DateUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    @landing = Landing.new(@driver)
    @login = Login.new(@driver)
    @common = Common.new(@driver)
    @manage_setting = Manage_Settings.new(@driver)

  end

  after(:all) do
    @driver.close
  end

  context 'AC#VARUT-136|TC VARUT#137: Validate display of VAMF Staff Login Page' do
    it "Login Button" do
      @landing.login_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.has_expected_title?).to eq(true)
      expect(@landing.login_element.visible?).to eq(true)
    end

    it "Login screen " do
      @landing.login
      @login.login_element.when_visible(TIME_OUT_LIMIT)

      expect(@login.has_expected_title?).to eq(true)
      @login.login_with("ACCESS7", "VERIFY7!", "BOSTON HCS VAMC")
    end

    it "Logged in" do
      @common.waitWhileSpinnerPresent()

      @landing.footerUserInfo_element.when_visible(TIME_OUT_LIMIT)

      Watir::Wait.until {@landing.footerUserInfo == "Logged in as PROVIDER, SEVEN"}

      expect(@landing.appVersion).to eq("VAR Utility - v1.0.0")
      expect(@landing.footerUserInfo).to eq("Logged in as PROVIDER, SEVEN")
    end
  end

  context "AC#VARUT-130|TC#VARUT-131:  Validate Authenticated and Authorization Landing page" do
    it "Header Bar, Home icon, Alt text Home" do
       @landing.home_btn_element.when_visible(TIME_OUT_LIMIT)
       expect(@landing.home_btn_element.attribute("aria-label")).to eq("Home")
       @landing.home_btn
       expect(@landing.primary_header).to eq("Home")
    end

    it "Primary Header - Var Utility" do
      expect(@landing.title).to eq("VAR Utility")
    end

    it "Primary View - displayed (panel 2 and 3)" do
      expect(@landing.primary_header).to eq("Home")
      expect(@landing.secondary_header).to eq("Manage Settings")
    end

    it "Panel 2 - Manage Settings options" do
      #two options - in seprate story
        index = @manage_setting.getOptionIndex("Direct Scheduling")
        expect(@manage_setting.getNthOptionName(index)).to eq("Direct Scheduling")
    end

    it "Panel 3 - Details" do
      expect(@landing.primary_header).to eq("Home")
      homeWelcomeMessage = @landing.home_welcome_message.split("\n")

     #for screen reader
      expect(homeWelcomeMessage[0]).to eq( "Welcome SEVEN PROVIDER")

      #expect(homeWelcomeMessage[1]).to eq( "Welcome SEVEN PROVIDER")
      today = getDateNthDaysAgo(0, "%B %d, %Y")
      expect(homeWelcomeMessage[1]).to eq(today)
      expect(homeWelcomeMessage[2]).to eq("Facility: BOSTON HCS VAMC")
      expect(homeWelcomeMessage[3]).to eq("Update VAR Settings by selecting an option from the left hand menu. Note that any changes to this facility's settings also affect all of the facility's related divisions.")
    end
  end


  context "AC#VARUT-128|TC#VARUT-129:Utility - Validate user authorizatino to access VAR Utility " do
    it "Unauthorized landing page " do
       @common.logoutAndLogbackWithADifferentUser("ACCESS70", "VERIFY70!", "BOSTON HCS VAMC")
       @landing.footerUserInfo_element.when_visible(TIME_OUT_LIMIT)

       Watir::Wait.until {@landing.footerUserInfo == "Logged in as PROVIDER, SEVENTY"}

       expect(@landing.appVersion).to eq("VAR Utility - v1.0.0")
       expect(@landing.footerUserInfo).to eq("Logged in as PROVIDER, SEVENTY")

       unauthorizedMessage = @landing.unauthorized_welcome_message.split("\n")

       expect(unauthorizedMessage[0]).to eq( "Welcome SEVENTY PROVIDER")
       today = getDateNthDaysAgo(0, "%B %d, %Y")
       expect(unauthorizedMessage[1]).to eq(today)
       expect(unauthorizedMessage[2]).to eq("Your credentials do not support authorization to use this app. Please contact your supervisor for assistance.")

    end
  end

end





