require 'rubygems'
require 'rspec'
require 'watir-webdriver'

require_relative '../module/DriverUtility'
require_relative './rspec_helper'
require_relative '../pages/landing'
require_relative '../pages/modal'
require_relative '../pages/base/base'
require_relative '../pages/login'
require_relative '../common/common'
require_relative '../pages/manage_settings'
require_relative '../module/DateUtility'
require_relative '../helper/table'
require_relative '../pages/error_validation'
require_relative '../pages/manage_settings/direct_scheduling'
require_relative '../module/database/MongoUtility'


describe '[Story VARUT-13 : Utility - Direct Appointments
                                   - View/Edit Service Patient History Limit],
          [Story VARUT-60 : Utility - Navigate without Saving Warning],
          [Story VARUT-219: Utility - Direct Scheduling Screen - Update labels],
          [stort VARUT-217: Utility - Display Service Stop Codes]'  do
  include DriverUtility
  include DateUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    @db = connectToMongoDB("var-utility")
    @landing = Landing.new(@driver)
    @login = Login.new(@driver)
    @common = Common.new(@driver)
    @base = Base.new(@driver)
    @direct_scheduling = Direct_Scheduling.new(@driver)
    @manage_setting = Manage_Settings.new(@driver)
    @table = Table.new(@driver)
    @error = Error_Validation.new(@driver)
    @modal = Modal.new(@driver)

  end

  after(:all) do
    @driver.close
  end

  context 'AC#VARUT-187|TC#VARUT-186: Test - View/Edit Service Patient History Limit' do
    #Reset Data in Mongo DB
    it "Remove Mongo" do
      removeCollection("directBookingEligibilityCriteria", @db)
    end
    it "Login" do
      @landing.login_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.login_element.visible?).to eq(true)
      @landing.login
      @login.login_element.when_visible(TIME_OUT_LIMIT)
      expect(@login.has_expected_title?).to eq(true)
      @login.login_with("ACCESS7", "VERIFY7!", "BOSTON HCS VAMC")

      @common.waitWhileSpinnerPresent()

      @landing.footerUserInfo_element.when_visible(TIME_OUT_LIMIT)

      Watir::Wait.until {@landing.footerUserInfo == "Logged in as PROVIDER, SEVEN"}
      expect(@landing.footerUserInfo).to eq("Logged in as PROVIDER, SEVEN")
    end


    context '[AC#VARUT-266|TC#VARUT-267: Test - Validate column name change and drop down value changes],
             [AC#VARUT-707|TC#VARUT-708: Test - Validate display of Stop codes for each Type of Care]' do
      it "Direct Scheduling Page" do
        @landing.home_btn_element.when_visible(TIME_OUT_LIMIT)
        expect(@landing.primary_header).to eq("Home")
        expect(@landing.secondary_header).to eq("Manage Settings")

        @manage_setting.clickOption('Direct Scheduling')
        expect(@landing.primary_header).to eq("Direct Scheduling")

        Watir::Wait.until {@table.tableList_elements.length > 1}

        expect(@table.tableList_elements.length).to eq(4)

        expect(@table.getNthTableHeader(0)).to eq("Type of Care\n(Primary/Secondary Stop Code)")
        expect(@table.getNthTableHeader(1)).to eq("Supported at this Facility?")
        expect(@table.getNthTableHeader(2)).to eq("* Last seen within (Months)")

        #Column1 data
        expect(@table.getTextForRowCol(1,1)).to eq("Primary Care\n(322, 323, 350)")
        expect(@table.getTextForRowCol(2,1)).to eq("Audiology\n(203)")
        expect(@table.getTextForRowCol(3,1)).to eq("Optometry\n(408)")
        expect(@table.getTextForRowCol(4,1)).to eq("Outpatient Mental Health\n(502/125, 502/185, 502/186, 502/187, 502/509, 502/510)")

        #Column2 data
        expect(@direct_scheduling.primarycareOption).to eq("Yes - PACT TEAM ASSIGNMENT")
        expect(@direct_scheduling.audiology_options).to eq(["No", "Yes - Any Veteran", "Yes - Based Upon Time Frame"])
        expect(@direct_scheduling.optometry_options).to eq(["No", "Yes - Any Veteran", "Yes - Based Upon Time Frame"])
        expect(@direct_scheduling.outpatientMentalHealth_options).to eq(["No", "Yes - Any Veteran", "Yes - Based Upon Time Frame"])

      end

      it "Validate Type of Care = Primary Care" do
        #Type of care = Primary Care
        #Last Seen Within column - no options
        expect(@direct_scheduling.primarycareOptionLastSeen).to eq("")
      end

      it "Validate Type of Care = Audiology" do
        #Type of Care = Audiology
        @direct_scheduling.audiology = "No"
        expect(@direct_scheduling.audiologyLastSeen_element.exists?).to eq(false)

        @direct_scheduling.audiology = "Yes - Any Veteran"
        expect(@direct_scheduling.audiologyLastSeen_element.exists?).to eq(false)

      end

      it "Validate Type of Care = Optometry" do
        #Type of Care = Optometry
        @direct_scheduling.optometry = "No"
        expect(@direct_scheduling.optometryLastSeen_element.exists?).to eq(false)

        @direct_scheduling.optometry = "Yes - Any Veteran"
        expect(@direct_scheduling.optometryLastSeen_element.exists?).to eq(false)

      end

      it "Validate Type of Care = Outpatient Mental Health" do
        #Type of Care = Outpatient Mental Health
        @direct_scheduling.outpatientMentalHealth = "No"
        expect(@direct_scheduling.outpatientMentalHealthLastSeen_element.exists?).to eq(false)

        @direct_scheduling.outpatientMentalHealth = "Yes - Any Veteran"
        expect(@direct_scheduling.outpatientMentalHealthLastSeen_element.exists?).to eq(false)

      end

      it "Validate Confirmation Modal on Save" do
        #Audiology
        @direct_scheduling.audiology = "Yes - Based Upon Time Frame"
        expect(@direct_scheduling.audiologyLastSeen_element.exists?).to eq(true)
        expect(@direct_scheduling.audiologyLastSeen_options).to eq(["Select", "24 months (730 days)", "12 months (365 days)"])

        #Select Duration and Save.
        @direct_scheduling.audiologyLastSeen = "24 months (730 days)"

        #Optometry
        @direct_scheduling.optometry = "Yes - Based Upon Time Frame"
        expect(@direct_scheduling.optometryLastSeen_element.exists?).to eq(true)
        expect(@direct_scheduling.optometryLastSeen_options).to eq(["Select", "24 months (730 days)", "12 months (365 days)"])

        #Select Duration and Save.
        @direct_scheduling.optometryLastSeen = "12 months (365 days)"

        #Outpatient Mental Health
        @direct_scheduling.outpatientMentalHealth = "Yes - Based Upon Time Frame"
        expect(@direct_scheduling.outpatientMentalHealthLastSeen_element.exists?).to eq(true)
        expect(@direct_scheduling.outpatientMentalHealthLastSeen_options).to eq(["Select", "24 months (730 days)", "12 months (365 days)"])

        #Select Duration and Save.
        @direct_scheduling.outpatientMentalHealthLastSeen = "24 months (730 days)"

        @direct_scheduling.bottomSave

        #Validate Confirmation Modal
        @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)

        expect(@modal.modalTitle).to eq("Confirmation")
        expect(@modal.content).to eq("The Direct Scheduling settings have been saved.")

        @modal.ok

        Watir::Wait.until {@table.tableList_elements.length > 1}

        @direct_scheduling.audiology_element.when_visible(TIME_OUT_LIMIT)

        #Validate that the selections are saved.
        expect(@direct_scheduling.audiology).to eq("Yes - Based Upon Time Frame")
        expect(@direct_scheduling.audiologyLastSeen).to eq("24 months (730 days)")
        expect(@direct_scheduling.optometry).to eq("Yes - Based Upon Time Frame")
        expect(@direct_scheduling.optometryLastSeen).to eq("12 months (365 days)")
        expect(@direct_scheduling.outpatientMentalHealth).to eq("Yes - Based Upon Time Frame")
        expect(@direct_scheduling.outpatientMentalHealthLastSeen).to eq("24 months (730 days)")

      end

      it "Retrieve mongo" do
        #getDocumentByObjId(collectionName, objId, columnName, db)
        #value =  getDocumentByObjId("directBookingEligibilityCriteria", "523", "coreSettings", @db)

        value = getNthCoreSettings("directBookingEligibilityCriteria", "523", 0, @db)
        expect("").to eq(value['patientHistoryRequired'].to_s)
        expect(PRIMARY_CARE).to eq(value['typeOfCare'].to_s)

        value = getNthCoreSettings("directBookingEligibilityCriteria", "523", 1, @db)
        expect("Yes").to eq(value['patientHistoryRequired'].to_s)
        expect(AUDIOLOGY).to eq(value['typeOfCare'].to_s)
        expect("730").to eq(value['patientHistoryDuration'].to_s)

        value = getNthCoreSettings("directBookingEligibilityCriteria", "523", 2, @db)
        expect("Yes").to eq(value['patientHistoryRequired'].to_s)
        expect(OPTOMETRY).to eq(value['typeOfCare'].to_s)
        expect("365").to eq(value['patientHistoryDuration'].to_s)

        value = getNthCoreSettings("directBookingEligibilityCriteria", "523", 3, @db)
        expect("Yes").to eq(value['patientHistoryRequired'].to_s)
        expect(MENTAL_HEALTH).to eq(value['typeOfCare'].to_s)
        expect("730").to eq(value['patientHistoryDuration'].to_s)


      end

      it "Error validation" do
        #Last Seen in Months is a required field
        #Click Save without selecting a value for last seen for Audiology Optometry and Outpatient Mental health

        @direct_scheduling.audiologyLastSeen = "Select"
        @direct_scheduling.optometryLastSeen = "Select"
        @direct_scheduling.outpatientMentalHealthLastSeen = "Select"
        @direct_scheduling.topSave

        @error.errorSummaryHeader_element.when_visible(TIME_OUT_LIMIT)

        verifyErrorMessage("Last Seen Within (Months) " + AUDIOLOGY + " field is required")
        verifyErrorMessage("Last Seen Within (Months) " + OPTOMETRY + " field is required")
        verifyErrorMessage("Last Seen Within (Months) " + MENTAL_HEALTH + " field is required")

        #Click Cancel reverts back to the last saved state and error messages are not displayed
        @direct_scheduling.topCancel

        Watir::Wait.until {@table.tableList_elements.length > 1}

        expect(@error.errorSummaryHeader_element.exists?).to eq(false)
        expect(@error.isErrorMsgDisplayed?("Last Seen Within (Months) " + AUDIOLOGY + " field is required")).to eq(false)
        expect(@error.isErrorMsgDisplayed?("Last Seen Within (Months) " + OPTOMETRY + " field is required")).to eq(false)
        expect(@error.isErrorMsgDisplayed?("Last Seen Within (Months) " + MENTAL_HEALTH + " field is required")).to eq(false)

      end

      it "Logout and Log back in as different user for same location to verify the last saved data is displayed" do
        @common.logoutAndLogbackWithADifferentUser("ACCESS50", "VERIFY50!", "BOSTON HCS VAMC")
        @landing.footerUserInfo_element.when_visible(TIME_OUT_LIMIT)

        Watir::Wait.until {@landing.footerUserInfo == "Logged in as PROVIDER, FIFTY"}
        expect(@landing.footerUserInfo).to eq("Logged in as PROVIDER, FIFTY")

        expect(@landing.primary_header).to eq("Home")
        expect(@landing.secondary_header).to eq("Manage Settings")

        @manage_setting.clickOption('Direct Scheduling')
        expect(@landing.primary_header).to eq("Direct Scheduling")

        Watir::Wait.until {@table.tableList_elements.length > 1}

        #Validate the selections
        expect(@direct_scheduling.audiology).to eq("Yes - Based Upon Time Frame")
        expect(@direct_scheduling.audiologyLastSeen).to eq("24 months (730 days)")
        expect(@direct_scheduling.optometry).to eq("Yes - Based Upon Time Frame")
        expect(@direct_scheduling.optometryLastSeen).to eq("12 months (365 days)")
        expect(@direct_scheduling.outpatientMentalHealth).to eq("Yes - Based Upon Time Frame")
        expect(@direct_scheduling.outpatientMentalHealthLastSeen).to eq("24 months (730 days)")

      end

      context 'AC#VARUT-211|TC#VARUT-212: Utility - Navigate without Save Confirmation Modal Validate' do
        it "Navigate without save and validate changes are not saved" do
          #Select different values for each field other than what is being saved.
          @direct_scheduling.audiology = "Yes - Any Veteran"
          @direct_scheduling.optometry = "Yes - Any Veteran"
          @direct_scheduling.outpatientMentalHealth = "Yes - Any Veteran"

          #Click the home icon and validate the confirmation modal

          @base.home_btn

          @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)

          expect(@modal.modalTitle).to eq("Confirmation")
          expect(@modal.content).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")
          @modal.return

          Watir::Wait.until {@table.tableList_elements.length > 1}

          #Validate the last selected values
          expect(@direct_scheduling.audiology).to eq("Yes - Any Veteran")
          expect(@direct_scheduling.audiologyLastSeen_element.exists?).to eq(false)
          expect(@direct_scheduling.optometry).to eq("Yes - Any Veteran")
          expect(@direct_scheduling.optometryLastSeen_element.exists?).to eq(false)
          expect(@direct_scheduling.outpatientMentalHealth).to eq("Yes - Any Veteran")
          expect(@direct_scheduling.outpatientMentalHealthLastSeen_element.exists?).to eq(false)

          #Select Continue in the confirmation modal
          #@base.home_btn
          button_element = @driver.button( :id=>'home-btn')
          @driver.execute_script("$(arguments[0]).click();",button_element)

          @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)
          expect(@modal.modalTitle).to eq("Confirmation")

          @modal.continue

          @landing.home_btn_element.when_visible(TIME_OUT_LIMIT)

          #Go back to Direct Scheduling and verify the last saved selections are displayed
          @landing.home_btn_element.when_visible(TIME_OUT_LIMIT)
          expect(@landing.primary_header).to eq("Home")
          expect(@landing.secondary_header_element.when_present(TIME_OUT_LIMIT))


          #expect(@manage_setting.manage_settings_options_elements.when_present(TIME_OUT_LIMIT))
          sleep (3)
          @manage_setting.clickOption('Direct Scheduling')

          Watir::Wait.until {@table.tableList_elements.length > 1}

          expect(@direct_scheduling.audiology).to eq("Yes - Based Upon Time Frame")
          expect(@direct_scheduling.audiologyLastSeen).to eq("24 months (730 days)")
          expect(@direct_scheduling.optometry).to eq("Yes - Based Upon Time Frame")
          expect(@direct_scheduling.optometryLastSeen).to eq("12 months (365 days)")
          expect(@direct_scheduling.outpatientMentalHealth).to eq("Yes - Based Upon Time Frame")
          expect(@direct_scheduling.outpatientMentalHealthLastSeen).to eq("24 months (730 days)")

        end
      end
    end
  end
end





