require 'page-object'
require 'rspec'
require_relative '../../pages/base/base'

class Request_Settings < Base
  include PageObject
  def initialize(driver)
    super(driver)
  end

#Require Relationship to Schedule options

#Primary Care

  span(:primarycareOption, :css => ".list-table span:nth-child(2) .cell-content")
  span(:primarycareOptionLastSeen, :css => ".list-table span:nth-child(3) .cell-content")

  select_list(:primaryCare, :id => "primary-care-request-supported")
  select_list(:audiology, :id => "audiology-request-supported")
  select_list(:optometry, :id => "optometry-request-supported")
  select_list(:outpatientMentalHealth, :id => "outpatient-mental-health-request-supported")


#Last seen within (months) column
  select_list(:audiologyLastSeen, :id => "audiology-request-last-seen")
  select_list(:optometryLastSeen, :id => "optometry-request-last-seen")
  select_list(:outpatientMentalHealthLastSeen, :id => "outpatient-mental-health-request-last-seen")

 #submitted request limit column
  select_list(:primaryCareRequestLimit, :id=>'primary-care-request-limit')
  select_list(:audiologyRequestLimit, :id=>'audiology-request-limit')
  select_list(:optometryRequestLimit, :id=>'optometry-request-limit')
  select_list(:outpatientMentalHealthRequestLimit, :id=>'outpatient-mental-health-request-limit')

#Buttons
  button(:topCancel, :id => "request-top-reset-btn")
  button(:topSave, :id => "request-top-save-btn")
  button(:bottomCancel, :id => "request-bottom-reset-btn")
  button(:bottomSave, :id => "request-bottom-save-btn")

end



