require 'page-object'
require 'rspec'
require_relative '../../pages/base/base'

class Direct_Scheduling < Base
  include PageObject
  def initialize(driver)
    super(driver)
  end

#Require Relationship to Schedule options

#Primary Care

  span(:primarycareOption, :css => ".list-table ul li:nth-child(1) span:nth-child(2) .cell-content")
  span(:primarycareOptionLastSeen, :css => ".list-table ul li:nth-child(2) span:nth-child(3)")

  select_list(:primaryCare, :id => "primary-care-direct-scheduling-supported")
  select_list(:audiology, :id => "audiology-direct-scheduling-supported")
  select_list(:optometry, :id => "optometry-direct-scheduling-supported")
  select_list(:outpatientMentalHealth, :id => "outpatient-mental-health-direct-scheduling-supported")


#Last seen within (months) column
  select_list(:audiologyLastSeen, :id => "audiology-direct-scheduling-last-seen")
  select_list(:optometryLastSeen, :id => "optometry-direct-scheduling-last-seen")
  select_list(:outpatientMentalHealthLastSeen, :id => "outpatient-mental-health-direct-scheduling-last-seen")

#Buttons
  button(:topCancel, :id => "top-reset-btn")
  button(:topSave, :id => "top-save-btn")
  button(:bottomCancel, :id => "bottom-reset-btn")
  button(:bottomSave, :id => "bottom-save-btn")

end



