require 'page-object'

class Login
  include PageObject

  text_field(:accessCode, :id => 'name-c')
  text_field(:verifyCode, :id => 'password')
  text_field(:station, :id => 'va-hospital')
  button(:login, :id => 'loginButton')
  button(:clear, :id => 'resetLogin')
  h2(:title, :css => "h2")
  #link(:autoCompleteStation,:css => '#autocomplete li:nth-child(2) a')
  elements(:autoCompleteStation, :link, :css=> '#autocomplete li a')
  expected_title "PROVIDER LOGIN"

  def login_with(access_code, verify_code, station)
    Watir::Wait.until {login?}
    accessCode_element.when_visible
    self.accessCode = access_code
    self.verifyCode = verify_code
    self.station = station[0..1]

    Watir::Wait.until {self.autoCompleteStation_elements.length > 0}
    puts ("Station AutoComplete count: " + self.autoCompleteStation_elements.length.to_s )

   # Watir::Wait.until {self.autoCompleteStation_element.text.include?(station)}
    self.class.link(:stationName, :css=>"a[data-facility-name='" + station + "']")
    self.stationName
    sleep 1.5
    self.login

  end

end