require 'rubygems'
require 'watir-webdriver'
require 'page-object'
require_relative 'base/base'

class Launchpad < Base
  include PageObject

  def initialize(driver)
    super(driver)
  end
  h1(:launchpadTitle, :css => '#header h1.ui-title')

  expected_title "Launchpad"
  a(:login, :id => 'footer-logout-btn')
  list_item(:footer_name, :id =>'footer-username')
  link(:var_utility, :css=>'a[href="/var-utility/"]')
  button(:launchpad_eula_accept, :id=>'accept-btn')
  h2(:var_utility_name, :css=>'a[href="/var-utility/"] h2')
  span(:var_utility_description, :css=>'a[href="/var-utility/"] span')
end