require 'rubygems'
require 'watir-webdriver'

require_relative '../pages/landing'
require_relative '../pages/login'
require_relative '../pages/user_menu'
require_relative '../pages/launchpad'
require_relative '../module/DriverUtility'

class Common

  def initialize(driver)
    @driver = driver
    @landing = Landing.new(@driver)
    @login = Login.new(@driver)
    @launchpad = Launchpad.new(@driver)
    @user_menu = UserMenuOption.new(@driver)
  end

  def loginEndsOnHome(access_code, verify_code, station)
    @landing.login_element.when_visible(TIME_OUT_LIMIT)

    @landing.login
    @login.login_element.when_visible(TIME_OUT_LIMIT)

    @login.login_with(access_code, verify_code, station)

    waitWhileSpinnerPresent()
    @landing.footerUserInfo_element.when_visible(TIME_OUT_LIMIT)
  end

  def logoutAndLogbackWithADifferentUser(access_code, verify_code, station)
    @user_menu.userMenu_element.when_visible(TIME_OUT_LIMIT)
    @user_menu.userMenu_element.click

    @user_menu.logOut_element.when_present

    button_element = @driver.button(:id => 'logout')
    @driver.execute_script("$(arguments[0]).click();",button_element)

    #@user_menu.logOut
    waitWhileSpinnerPresent

    sleep(3)

    Watir::Wait.until {@launchpad.launchpadTitle == "Launchpad"}
    #@launchpad.launchpadTitle_element.when_visible(TIME_OUT_LIMIT)

    @driver.goto(BASE_URL)
    @landing.login_element.when_visible(TIME_OUT_LIMIT)
    loginEndsOnHome(access_code, verify_code, station)
  end

  def waitWhileSpinnerPresent()
    spinner = @driver.div :css => '.content-loading'
    spinner.wait_while_present(TIME_OUT_LIMIT)
  end


end