#!/bin/bash

typeset jsonFile=$1
typeset jsonFileBasename=`basename $jsonFile`

typeset base=mongoImport
typeset deployScript=${base}.sh
typeset deployLog=${base}.log
typeset errorLog=${base}.error
typeset deploymentsDir=$VAGRANT_DIR/deployments

rm -f $errorLog
if [ -z $VAGRANT_DIR ] || [ ! -r $VAGRANT_DIR/Vagrantfile ] ; then
	echo '$VAGRANT_DIR must be defined and contain a valid Vagrantfile.  Aborted.' > $errorLog
	exit 1
fi

cat <<-'EOF' > $VAGRANT_DIR/$deployScript
#!/bin/bash

mongoimport --db var-utility --collection clinical-services --drop \
	--file "/vagrant/deployments/$1" --jsonArray -u var-utility -p var-utility
EOF

chmod +x $VAGRANT_DIR/$deployScript
mkdir -p $deploymentsDir
cp $jsonFile $deploymentsDir
cd $VAGRANT_DIR
vagrant ssh vamf_mongo --command "/vagrant/$deployScript $jsonFileBasename > $deployLog 2>&1"
