package gov.va.vamf.scheduling.varutility.service;


import gov.va.vamf.scheduling.varutility.domain.ClinicalServices;
import gov.va.vamf.scheduling.varutility.domain.CoreSettings;
import gov.va.vamf.scheduling.varutility.domain.StopCode;
import gov.va.vamf.scheduling.varutility.domain.StopCodes;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static org.junit.Assert.assertEquals;

@ContextConfiguration(locations = { "classpath:applicationContext-test.xml" })
@RunWith(SpringJUnit4ClassRunner.class)
public class CoreSettingsServiceTest {

    CoreSettingsService coreSettingsService;

    List<ClinicalServices>  clinicalServices;

    @Before
    public void setup() {
        clinicalServices = createClinicalServices();
        coreSettingsService = new CoreSettingsService();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testCreateDefaultCoreSettings() {
        CoreSettings coreSettings = coreSettingsService.createDefaultCoreSettings(clinicalServices);
        assertEquals(coreSettings.size(), clinicalServices.size());
    }

    @Test
    public void testUpdateCriteriaCoreSettingsWillAddCoreSetting() {
        CoreSettings coreSettings = coreSettingsService.createDefaultCoreSettings(clinicalServices);
        assertEquals(coreSettings.size(), 3);
        ClinicalServices cs = new ClinicalServices();
        cs.setId("150");
        cs.setName("Test Radiology");
        cs.setCreatedBy("Test User");
        cs.setCreatedDate(new Date());
        StopCodes stopCodes = new StopCodes();
        StopCode sc = new StopCode();
        sc.setPrimary("222");
        sc.setSecondary("333");
        stopCodes.add(sc);
        cs.setStopCodes(stopCodes);
        clinicalServices.add(cs);
        coreSettings = coreSettingsService.updateCriteriaCoreSettings(coreSettings, clinicalServices);
        assertEquals(coreSettings.size(), 4);
    }

    @Test
    public void testUpdateCriteriaCoreSettingsWillRemoveCoreSetting() {
        CoreSettings coreSettings = coreSettingsService.createDefaultCoreSettings(clinicalServices);
        assertEquals(coreSettings.size(), 3);
        clinicalServices.remove(0);
        coreSettings = coreSettingsService.updateCriteriaCoreSettings(coreSettings, clinicalServices);
        assertEquals(coreSettings.size(), 2);
    }

    private List<ClinicalServices>  createClinicalServices() {
        List<ClinicalServices> clinicalServices = new ArrayList<ClinicalServices>();
        ClinicalServices cs1 = new ClinicalServices();
        cs1.setId("323");
        cs1.setName("PRIMARY CARE");
        StopCodes stopCodes1 = new StopCodes();
        stopCodes1.add(new StopCode("323", ""));
        stopCodes1.add(new StopCode("350", ""));
        cs1.setStopCodes(stopCodes1);
        cs1.setCreatedBy("test user");
        cs1.setCreatedDate(new Date());
        cs1.setModifiedBy("test update user");
        cs1.setLastModifiedDate(new Date());
        clinicalServices.add(cs1);
        ClinicalServices cs2 = new ClinicalServices();
        cs2.setId("408");
        cs2.setName("OPTOMETRY");
        StopCodes stopCodes2 = new StopCodes();
        stopCodes2.add(new StopCode("408", ""));
        cs2.setStopCodes(stopCodes2);
        cs2.setCreatedBy("test user");
        cs2.setCreatedDate(new Date());
        cs2.setModifiedBy("test update user");
        cs2.setLastModifiedDate(new Date());
        clinicalServices.add(cs2);
        ClinicalServices cs3 = new ClinicalServices();
        cs3.setId("203");
        cs3.setName("AUDIOLOGY");
        StopCodes stopCodes3 = new StopCodes();
        stopCodes3.add(new StopCode("203", ""));
        stopCodes3.add(new StopCode("31", "35"));
        cs3.setStopCodes(stopCodes3);
        cs3.setCreatedBy("test user");
        cs3.setCreatedDate(new Date());
        cs3.setModifiedBy("test update user");
        cs3.setLastModifiedDate(new Date());
        clinicalServices.add(cs3);
        return clinicalServices;
    }

}
