package gov.va.vamf.scheduling.varutility.service;

import gov.va.vamf.scheduling.varutility.datalayer.RequestEligibilityCriteriaRepository;
import gov.va.vamf.scheduling.varutility.domain.ClinicalServices;
import gov.va.vamf.scheduling.varutility.domain.CoreSettings;
import gov.va.vamf.scheduling.varutility.domain.RequestEligibilityCriteria;
import gov.va.vamf.scheduling.varutility.linkbuilder.LinkBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.core.UriInfo;
import java.util.List;

@Service
public class RequestEligibilityCriteriaService {

    @Autowired
    private RequestEligibilityCriteriaRepository requestEligibilityCriteriaRepository;

    @Autowired
    private CoreSettingsService coreSettingsService;

    public RequestEligibilityCriteria fetchRequestEligibiltyCriteria(String siteCode, List<ClinicalServices> clinicalServices, UriInfo uriInfo) {
        RequestEligibilityCriteria requestEligibilityCriteria = requestEligibilityCriteriaRepository.findById(siteCode);
        if (requestEligibilityCriteria == null) {
            requestEligibilityCriteria = new RequestEligibilityCriteria();
            requestEligibilityCriteria.setId(siteCode);
            requestEligibilityCriteria.setRequestSettings(coreSettingsService.createDefaultCoreSettings(clinicalServices));
        } else {
            CoreSettings coreSettings = requestEligibilityCriteria.getRequestSettings();
            requestEligibilityCriteria.setRequestSettings(coreSettingsService.updateCriteriaCoreSettings(coreSettings, clinicalServices));
            LinkBuilder.fillLink(requestEligibilityCriteria, uriInfo.getRequestUri());
        }
        return requestEligibilityCriteria;
    }

    public RequestEligibilityCriteria saveRequestEligibilityCriteria (RequestEligibilityCriteria requestEligibilityCriteria) {
        RequestEligibilityCriteria savedRequestEligibilityCriteria = requestEligibilityCriteriaRepository.save(requestEligibilityCriteria);
        return savedRequestEligibilityCriteria;
    }

    public RequestEligibilityCriteria updateRequestEligibilityCriteria (RequestEligibilityCriteria requestEligibilityCriteria) {
        RequestEligibilityCriteria updatedRequestEligibilityCriteria = requestEligibilityCriteriaRepository.save(requestEligibilityCriteria);
        return updatedRequestEligibilityCriteria;
    }
}
