package gov.va.vamf.scheduling.varutility.service;


import gov.va.vamf.scheduling.varutility.domain.ClinicalServices;
import gov.va.vamf.scheduling.varutility.domain.CoreSetting;
import gov.va.vamf.scheduling.varutility.domain.CoreSettings;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static gov.va.vamf.scheduling.varutility.domain.CoreSettings.PRIMARY_CARE_ID;

@Service
public class CoreSettingsService {

    public CoreSettings createDefaultCoreSettings(List<ClinicalServices> clinicalServices) {

        CoreSettings cs = new CoreSettings();
        for (ClinicalServices service: clinicalServices) {
            String serviceName = service.getName();
            String serviceId = service.getId();
            cs = createCoreSettings(cs, serviceName, serviceId);
        }
        return cs;
    }

    public CoreSettings updateCriteriaCoreSettings(CoreSettings coreSettings, List<ClinicalServices> services) {

        Map<String,String> coreSettingsIds = new HashMap<String, String>();
        Map<String, String> servicesIds = new HashMap<String, String>();
        CoreSettings newCoreSettings = new CoreSettings();
        for (CoreSetting coreSetting: coreSettings) {
            coreSettingsIds.put(coreSetting.getId(), coreSetting.getTypeOfCare());
        }
        for (ClinicalServices clinicalService: services) {
            servicesIds.put(clinicalService.getId(), clinicalService.getName());
        }
        coreSettingsIds.keySet().retainAll(servicesIds.keySet());
        for (CoreSetting coreSetting: coreSettings) {
            String id = coreSetting.getId();
            if (coreSettingsIds.containsKey(id)) {
                coreSetting.setTypeOfCare(servicesIds.get(id));
                newCoreSettings.add(coreSetting);
            }
        }
        servicesIds.keySet().removeAll(coreSettingsIds.keySet());

        for (Map.Entry<String, String> entry: servicesIds.entrySet()) {
            newCoreSettings = createCoreSettings(newCoreSettings, entry.getValue(), entry.getKey());
        }
        return newCoreSettings;
    }

    private CoreSettings createCoreSettings(CoreSettings coreSettings, String serviceName, String serviceId) {

        if (serviceId.equals(PRIMARY_CARE_ID)) {
            coreSettings.add(new CoreSetting(serviceId, serviceName, null, null));
        } else {
            coreSettings.add(new CoreSetting(serviceId, serviceName, "", 0));
        }
        return coreSettings;
    }
}
