package gov.va.vamf.scheduling.varutility.security;

import com.agilex.healthcare.mobilehealthplatform.security.Roles;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

import java.util.Collection;


public class StaffUserVoter<S> implements AccessDecisionVoter<S> {
    private final String IS_STAFF = "IS_STAFF";

    public StaffUserVoter() {}

    @Override
    public boolean supports(ConfigAttribute attribute) {
        return IS_STAFF.equals(attribute.getAttribute());
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return true;
    }

    // Abstain-able vote
    @Override
    public int vote(Authentication authentication, S s, Collection<ConfigAttribute> attributes) {

        for (ConfigAttribute attribute : attributes) {
            if (this.supports(attribute) && isStaffUser(authentication.getAuthorities())) {
                return AccessDecisionVoter.ACCESS_GRANTED;
            }
        }
        return AccessDecisionVoter.ACCESS_ABSTAIN;
    }

    private boolean isStaffUser(Collection<? extends GrantedAuthority> authorities) {
        return VoterHelper.hasRole(authorities, Roles.ROLE_STAFF);
    }
}
