package gov.va.vamf.scheduling.varutility.domain;

import com.fasterxml.jackson.annotation.JsonFormat;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
@XmlRootElement(name = "validationErrors")
public class ValidationErrors<T> extends ArrayList<ValidationError> implements Serializable {
    private static final long serialVersionUID = -8674522177519030220L;

    private T requestObject;

    public T getRequestObject() {
        return requestObject;
    }

    public void setRequestObject(T requestObject) {
        this.requestObject = requestObject;
    }

    @XmlElement()
    public List<ValidationError> getErrors() {
        List<ValidationError> list = new ArrayList<ValidationError>();
        for (ValidationError validationError : this) {
            list.add(validationError);
        }
        return list;
    }

    @XmlElement(name = "objectType")
    public String getObjectType() {
        return this.getClass().getSimpleName();
    }

    public void addIfNotNull(ValidationError e) {
        if (e != null) {
            this.add(e);
        }
    }
}
