package gov.va.vamf.scheduling.varutility.domain;

import com.agilex.healthcare.utility.NullChecker;
import gov.va.vamf.scheduling.varutility.exception.BasicValidationException;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@Document
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(namespace = Namespace.VarUtility)
public class RequestEligibilityCriteria extends DomainBaseObject {

    @XmlElement
    private CoreSettings requestSettings;

    public CoreSettings getRequestSettings() {
        return requestSettings;
    }

    public void setRequestSettings(CoreSettings requestSettings) {
        this.requestSettings = requestSettings;
    }

    public void validate(String siteCode, List<ClinicalServices> clinicalServices) {
        ValidationErrors<RequestEligibilityCriteria> errors = new ValidationErrors<RequestEligibilityCriteria>();

        if(NullChecker.isNullish(getId())) {
            errors.add(new ValidationError("id", "id is required."));
        } else if(! getId().equals(siteCode)) {
            errors.add(new ValidationError("id", "id must match Site Code."));
        }
        ArrayList<ValidationError> requestSettingsErrors = getRequestSettings().validate(clinicalServices);
        errors.addAll(requestSettingsErrors);

        if(errors.size() > 0) {
            errors.setRequestObject(this);
            throw new BasicValidationException(errors);
        }
    }

    public void cleanupDataForSave() {
        for(CoreSetting cs : this.getRequestSettings()) {
            if(agilex.commons.NullChecker.isNullish(cs.getPatientHistoryRequired()) || cs.getPatientHistoryRequired().equals("No")) {
                cs.setPatientHistoryDuration(0);
            }
        }
    }
}
