package gov.va.vamf.scheduling.varutility.domain;

import com.agilex.healthcare.utility.NullChecker;
import gov.va.vamf.scheduling.varutility.exception.BasicValidationException;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@Document
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(namespace = Namespace.VarUtility)
public class DirectBookingEligibilityCriteria extends DomainBaseObject {

    @XmlElement
    private CoreSettings coreSettings;

    public CoreSettings getCoreSettings() {
        return coreSettings;
    }

    public void setCoreSettings(CoreSettings coreSettings) {
        this.coreSettings = coreSettings;
    }


    public void validate(String siteCode, List<ClinicalServices> clinicalServices) {
        ValidationErrors<DirectBookingEligibilityCriteria> errors = new ValidationErrors<DirectBookingEligibilityCriteria>();

        if(NullChecker.isNullish(getId())) {
            errors.add(new ValidationError("id", "id is required."));
        } else if(! getId().equals(siteCode)) {
            errors.add(new ValidationError("id", "id must match Site Code."));
        }
        ArrayList<ValidationError> coreSettingsErrors = getCoreSettings().validate(clinicalServices);
        errors.addAll(coreSettingsErrors);

        if(errors.size() > 0) {
            errors.setRequestObject(this);
            throw new BasicValidationException(errors);
        }
    }

    public void cleanupDataForSave() {
        this.getCoreSettings().cleanupDataForSave();
    }
}
