package gov.va.vamf.scheduling.varutility.datalayer;


import gov.va.vamf.scheduling.varutility.domain.CoreSetting;
import gov.va.vamf.scheduling.varutility.domain.CoreSettings;
import gov.va.vamf.scheduling.varutility.domain.DirectBookingEligibilityCriteria;
import gov.va.vamf.scheduling.varutility.utils.SpringBasedIntegrationRepo;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;


public class DirectBookingEligibilityCriteriaRepositoryTest extends SpringBasedIntegrationRepo {

   @Autowired
   private DirectBookingEligibilityCriteriaRepository directBookingEligibilityCriteriaRepository;

    @Before
    public void setup() {
        createDirectBookingEligibilityCriteria();
    }

    @After
    public void tearDown() {
        directBookingEligibilityCriteriaRepository.deleteAll();
    }

    @Test
    public void testSave() {
        DirectBookingEligibilityCriteria d = new DirectBookingEligibilityCriteria();
        CoreSettings cs = new CoreSettings();
        CoreSetting c = new CoreSetting();
        c.setId("323");
        c.setTypeOfCare("test care primary care");
        c.setPatientHistoryRequired("yes");
        c.setPatientHistoryDuration(720);
        cs.add(c);
        d.setId("1");
        d.setCoreSettings(cs);
        DirectBookingEligibilityCriteria saved = directBookingEligibilityCriteriaRepository.save(d);
        assertEquals("1", saved.getId());
    }

    @Test
    public void testFetchById() {
        DirectBookingEligibilityCriteria fetched = directBookingEligibilityCriteriaRepository.findById("540");
        assertNotNull(fetched);
        assertEquals("540", fetched.getId());
    }

    @Test
    public void testUpdate() {
        DirectBookingEligibilityCriteria fetched = directBookingEligibilityCriteriaRepository.findById("540");
        assertNotNull(fetched);
        assertEquals("540", fetched.getId());
        fetched.setModifiedBy("test user");
        DirectBookingEligibilityCriteria updated = directBookingEligibilityCriteriaRepository.save(fetched);
        assertEquals("540", updated.getId());
        assertEquals("test user", updated.getModifiedBy());
    }

    private void createDirectBookingEligibilityCriteria() {
        DirectBookingEligibilityCriteria d = new DirectBookingEligibilityCriteria();
        CoreSettings cs = new CoreSettings();
        CoreSetting c = new CoreSetting();
        c.setId("900");
        c.setTypeOfCare("test care");
        c.setPatientHistoryRequired("no");
        c.setPatientHistoryDuration(365);
        cs.add(c);
        d.setId("540");
        d.setCoreSettings(cs);
        directBookingEligibilityCriteriaRepository.save(d);
    }
}
