package gov.va.vamf.scheduling.varutility.datalayer;


import gov.va.vamf.scheduling.varutility.domain.ClinicalServices;
import gov.va.vamf.scheduling.varutility.domain.StopCode;
import gov.va.vamf.scheduling.varutility.domain.StopCodes;
import gov.va.vamf.scheduling.varutility.utils.SpringBasedIntegrationRepo;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;


public class ClinicalServicesRepositoryTest  extends SpringBasedIntegrationRepo {

    @Autowired
    private ClinicalServicesRepository clinicalServicesRepository;

    @Before
    public void setup() {
        createClinicalServices();
    }

    @After
    public void tearDown() {
        clinicalServicesRepository.deleteAll();
    }

    private void createClinicalServices() {
        ClinicalServices cs = new ClinicalServices();
        cs.setName("PRIMARY CARE");
        cs.setCreatedDate(new Date());
        cs.setCreatedBy("test user");
        StopCodes sc = new StopCodes();
        sc.add(new StopCode("340", ""));
        cs.setStopCodes(sc);
        cs.setId("340");
        clinicalServicesRepository.save(cs);
        ClinicalServices cs2 = new ClinicalServices();
        cs2.setName("GERIATRIC");
        cs2.setCreatedDate(new Date());
        cs2.setCreatedBy("test user two");
        StopCodes sc2 = new StopCodes();
        sc2.add(new StopCode("350", ""));
        cs2.setStopCodes(sc2);
        cs2.setId("350");
        clinicalServicesRepository.save(cs2);
    }

    @Test
    public void testFetchAll() {
        List<ClinicalServices> results = clinicalServicesRepository.findAll();
        assertNotNull(results);
        assertEquals(2, results.size());
    }

    @Test
    public void testFindById() {
        ClinicalServices clinicalServices = clinicalServicesRepository.findById("350");
        assertNotNull(clinicalServices);
        assertEquals("350", clinicalServices.getId());
    }


}
