package gov.va.vamf.scheduling.varutility.resources;


import gov.va.vamf.scheduling.varutility.clientapi.MobileHealthClientTestVersion;
import gov.va.vamf.scheduling.varutility.domain.CoreSetting;
import gov.va.vamf.scheduling.varutility.domain.CoreSettings;
import gov.va.vamf.scheduling.varutility.domain.RequestEligibilityCriteria;
import gov.va.vamf.scheduling.varutility.testutility.IntegrationTestConfiguration;
import gov.va.vamf.scheduling.varutility.testutility.TestHelper;
import org.junit.*;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import java.net.URI;

public class VarUtilityRequestCriteriaResourceTest {

    private static MobileHealthClientTestVersion client;
    private static Client jerseyClient;
    private static String testSiteCode = "test-site-code";

    @BeforeClass
    public static void startup() {
        client = TestHelper.createProviderClient();
        jerseyClient = client.getJerseyClient();
    }

    @AfterClass
    public static void destroy() {
        if (client != null) {
            client.getJerseyClient().close();
            client = null;
        }
    }

    @Before
    public void testPost() {
        RequestEligibilityCriteria postPayload = createCriteriaPayload(testSiteCode);

        RequestEligibilityCriteria newCriteria = jerseyClient.target(getResourceUri(testSiteCode))
                .request().accept(MediaType.APPLICATION_JSON).post(Entity.entity(postPayload, MediaType.APPLICATION_JSON), RequestEligibilityCriteria.class);

        Assert.assertTrue(newCriteria != null);
    }

    private RequestEligibilityCriteria createCriteriaPayload(String siteCode) {
        RequestEligibilityCriteria criteria = new RequestEligibilityCriteria();

        CoreSettings cs = new CoreSettings();
        cs.add(new CoreSetting("323", "PRIMARY CARE", "", null));
        cs.add(new CoreSetting("203", "AUDIOLOGY", "", null));
        cs.add(new CoreSetting("408", "OPTOMETRY", "", null));
        cs.add(new CoreSetting("502", "OUTPATIENT MENTAL HEALTH", "", null));

        criteria.setId(siteCode);
        criteria.setRequestSettings(cs);

        return criteria;
    }

    @Test
    public void testFetch() {
        RequestEligibilityCriteria criteria = jerseyClient.target(getResourceUri(testSiteCode))
                .request().accept(MediaType.APPLICATION_JSON).get(RequestEligibilityCriteria.class);

        Assert.assertTrue(criteria != null);
    }

    private static URI getResourceUri(String siteCode) {
        String uriFormat = String.format("%s/request-eligibility-criteria/site/%s",
                IntegrationTestConfiguration.getServerBaseUri(), siteCode);

        return UriBuilder.fromUri(uriFormat).build();
    }
}
