package gov.va.vamf.scheduling.varutility.clientapi;


import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import gov.va.vamf.scheduling.varutility.testutility.IntegrationTestConfiguration;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.oauth2.OAuth2ClientSupport;
import org.glassfish.jersey.jackson.JacksonFeature;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Feature;


public class JerseyFactory {
	private static final String DIGEST_AUTHENTICATION = "digest";
	private static final String BASIC_AUTHENTICATION = "basic";
	private static final String OAUTH_AUTHENTICATION = "oauth";
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(JerseyFactory.class);

	public static Client createJerseyClient(AuthenticationInfo authenticationInfo) {
		Client jerseyclient = ClientBuilder.newClient();
		logger.debug("creating jersey client");

		if (authenticationInfo != null) {
			Feature authFeature = null;
			String username = authenticationInfo.getUsername();
			String password = authenticationInfo.getPassword();
			String facilityName = authenticationInfo.getFacilityName();
			String facilityCode = authenticationInfo.getFacilityCode();

			if (authenticationInfo.getAuthtype().toLowerCase().contentEquals(BASIC_AUTHENTICATION)) {
				logger.debug(String.format("creating basic auth filter [%s][%s]", username, password));
				authFeature = HttpAuthenticationFeature.basic(username, password);
			} else if (authenticationInfo.getAuthtype().toLowerCase().contentEquals(DIGEST_AUTHENTICATION)) {
				logger.debug(String.format("creating digest auth filter [%s][%s]", username, password));
				authFeature = HttpAuthenticationFeature.digest(username, password);
			} else if (authenticationInfo.getAuthtype().toLowerCase().contentEquals(OAUTH_AUTHENTICATION)) {
				logger.debug(String.format("creating digest auth filter [%s][%s]", username, password));
				String accessToken = retrieveOauthToken(username, password, facilityName, facilityCode);
				authFeature = OAuth2ClientSupport.feature(accessToken);
			}

			if (authFeature == null) {
				throw new RuntimeException("Invalid authentication type " + authenticationInfo.getAuthtype());
			}
			JacksonJaxbJsonProvider provider = new JacksonJaxbJsonProvider();
			ObjectMapper mapper = new ObjectMapper();
			mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
			mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
			mapper.configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false);
			mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
			provider.setMapper(mapper);
			jerseyclient.register(provider);
			jerseyclient.register(authFeature);
			jerseyclient.register(JacksonFeature.class);

		}
		return jerseyclient;
	}

	private static String retrieveOauthToken(String username, String password, String facilityName, String facilityCode) {
		AuthenticationInfo authenticationInfo = constructAuthInfo(username, password, facilityName, facilityCode);
		OauthClient oauthClient = new OauthClient();
		String accessToken;
		try {
			accessToken = oauthClient.authenticate(authenticationInfo, null);
		} catch (RuntimeException e) {
			throw e;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return accessToken;
	}

	private static AuthenticationInfo constructAuthInfo(String username, String password, String facilityName, String facilityCode) {
		AuthenticationInfo authInfo = new AuthenticationInfo();
		authInfo.setUsername(username);
		authInfo.setPassword(password);
		authInfo.setFacilityName(facilityName);
		authInfo.setFacilityCode(facilityCode);
		authInfo.setClientId("MobileBlueButton");
		authInfo.setClientSecret("MBBWEB");
		authInfo.setExpectAuthenticationRequired(true);
		authInfo.setAuthorizeUrl(IntegrationTestConfiguration.getMHPAuthorizeURI());
		authInfo.setTokenUrl(IntegrationTestConfiguration.getMHPTokenURI());
		return authInfo;
	}

}
