package gov.va.vamf.scheduling.varutility.clientapi;

import com.agilex.healthcare.utility.NullChecker;

import java.net.URI;
import java.net.URISyntaxException;


public class JerseyClientHandle {
	private URI baseResourceUri = null;
	private AuthenticationInfo authenticationInfo = null;
	private boolean cacheJerseyClient = false;
	private javax.ws.rs.client.Client cachedJerseyClient = null;
	private boolean cacheJerseyWebTarget = false;
	private javax.ws.rs.client.WebTarget cachedJerseyWebTarget = null;

	public JerseyClientHandle(URI uri, AuthenticationInfo authenticationInfo) {
		if (uri == null) {
			throw new IllegalArgumentException("Invalid URI");
		}
		this.baseResourceUri = uri;
		this.authenticationInfo = authenticationInfo;
	}

	public JerseyClientHandle(String uri, AuthenticationInfo authenticationInfo) {
		if (NullChecker.isNullish(uri)) {
			throw new IllegalArgumentException("Invalid URI");
		}
		URI uriobject = null;
		try {
			uriobject = new URI(uri);
		} catch (URISyntaxException ex) {
			throw new RuntimeException("Unable to parse URI " + uri, ex);
		}
		this.baseResourceUri = uriobject;
		this.authenticationInfo = authenticationInfo;
	}

	public javax.ws.rs.client.Client getJerseyClient() {
		javax.ws.rs.client.Client jerseyclient = null;

		if (isCacheJerseyClientEnabled()) {
			jerseyclient = cachedJerseyClient;
		}
		if (jerseyclient == null) {
			jerseyclient = JerseyFactory.createJerseyClient(authenticationInfo);
			if (isCacheJerseyClientEnabled()) {
				cachedJerseyClient = jerseyclient;
			}
		}
		return jerseyclient;
	}

	public javax.ws.rs.client.WebTarget target() {
		javax.ws.rs.client.WebTarget jerseyWebTarget = null;
		if (isCacheJerseyWebTargetEnabled()) {
			jerseyWebTarget = cachedJerseyWebTarget;
		}
		if (jerseyWebTarget == null) {
			jerseyWebTarget = getJerseyClient().target(this.baseResourceUri);
			if (isCacheJerseyWebTargetEnabled()) {
				cachedJerseyWebTarget = jerseyWebTarget;
			}
		}
		return jerseyWebTarget;
	}

	public javax.ws.rs.client.WebTarget target(String uri) {
		URI uriobject = null;
		try {
			uriobject = new URI(uri);
		} catch (URISyntaxException ex) {
			throw new RuntimeException("Unable to parse URI " + uri, ex);
		}
		return target(uriobject);
	}

	public javax.ws.rs.client.WebTarget target(URI uri) {
		javax.ws.rs.client.Client client = getJerseyClient();
		return client.target(uri);
	}

	/**
	 * @return the cacheJerseyClient
	 */
	public boolean isCacheJerseyClientEnabled() {
		return cacheJerseyClient;
	}

	/**
	 * @param enabled
	 *            /disable caching of the jersey client
	 */
	public void setCacheJerseyClientEnabled(boolean enabled) {
		this.cacheJerseyClient = enabled;
	}

	/**
	 * @return the cacheJerseyWebResource
	 */
	public boolean isCacheJerseyWebTargetEnabled() {
		return cacheJerseyWebTarget;
	}

	/**
	 * @param enabled
	 *            the cacheJerseyWebResource to set
	 */
	public void setCacheJerseyWebTargetEnabled(boolean enabled) {
		this.cacheJerseyWebTarget = enabled;
	}

}
