#!/bin/sh
#
set -x

# Script variables
declare SCRIPT_NAME="${0##*/}"
declare SCRIPT_DIR="$(cd ${0%/*} ; pwd)"
declare ROOT_DIR="$PWD"

echo 
echo "SCRIPT_NAME: ${SCRIPT_NAME}"
echo "SCRIPT_DIR: ${SCRIPT_DIR}"
echo "ROOT_DIR: ${ROOT_DIR}"
echo

# Detect proper usage
if [ "$#" -ne "3" ] ; then
  echo -e "ERROR: Usage: $0 <username> <passwd> <my_repo.lst>"
  exit 1
fi

## Script variables
USERNAME="${1}"
PASSWD="${2}"
REPO_FILE="${3}"

declare -A PERM_MAP=( [soln-team-members]=write [mccf-team-members]=write [mccf-administrators]=admin [administrators]=admin ) 
echo "${!PERM_MAP[@]}"

for repo in $(cat ${REPO_FILE}) ; do
  PROJECTNAME="${repo}"
  if [ $PROJECTNAME ]
  then
    for team in "${!PERM_MAP[@]}"; do
      perm="${PERM_MAP[${team}]}"   
      echo
      echo "add ${perm} permission for ${team}"
      echo "curl --request PUT -u "${USERNAME}" https://api.bitbucket.org/1.0/group-privileges/halfaker/${PROJECTNAME}/halfaker/${team} --data \"${perm}\""
      curl --request PUT -u "${USERNAME}:${PASSWD}" "https://api.bitbucket.org/1.0/group-privileges/halfaker/${PROJECTNAME}/halfaker/${team}/" --data "${perm}"
      res=$?
      if [ 0 -eq ${res} ]; then 
        echo " --> success for ${PROJECTNAME} ${team} - ${perm}"
      else
        echo " --> ERROR: problem adding perm for ${team}: ${perm} to ${PROJECTNAME}\n ${res}" 
      fi
      sleep 1
    done
  else
    echo "${PROJECTNAME} not found"
  fi
done
