#!/bin/bash
#

# Script variables
declare SCRIPT_NAME="${0##*/}"
declare SCRIPT_DIR="$(cd ${0%/*} ; pwd)"
declare ROOT_DIR="$PWD"
declare ROLES_DIR="$(cd ../../roles ; pwd)"

echo 
echo "SCRIPT_NAME: ${SCRIPT_NAME}"
echo "SCRIPT_DIR: ${SCRIPT_DIR}"
echo "ROOT_DIR: ${ROOT_DIR}"
echo "ROLES_DIR: ${ROLES_DIR}"
echo

# Detect proper usage
if [ "$#" -ne "2" ] ; then
  echo -e "ERROR: Usage: $0 <username> <passwd>"
  exit 1
fi

## Script variables
USERNAME="${1}"
PASSWD="${2}"
REPO_FILE="rtcCheckinRequirements.yml"

USERNAME="${USERNAME//@/%40}"
PASSWD="${PASSWD//@/%40}"

if [[ ! -e ${REPO_FILE} ]]
then
  echo "${REPO_FILE} not found, exiting"
  exit 1
fi
echo "processing: ${REPO_FILE}"
REPOS=$(sed -n -e '/^\s*name/p' ${REPO_FILE} | cut -d':' -f 2 | sed 's/^ *//;s/ *$//')
for repo in ${REPOS} ; do
  PROJECT_NAME="${repo}"
  echo "--> ${PROJECT_NAME}"
  PROJECT_PATH="${ROLES_DIR}/${PROJECT_NAME}"
  echo "--> ${PROJECT_PATH}"
  # Make sure the required directories don't exist
  if [ -e "${PROJECT_PATH}" ] ; then
    echo -e "Role ${PROJECT_NAME} already exists!"
    cd "${ROLES_DIR}"
    rm -rf "${PROJECT_NAME}"
  fi
    # create get the role
  echo -e "INFO: getting role ${PROJECT_NAME}..."
  echo -e "===================================================="
  cd "${ROLES_DIR}"
  mkdir ${PROJECT_NAME}

  shopt -s extglob
  USERORIGIN="https://${USERNAME}:${PASSWD}@bitbucket.org/halfaker/${PROJECT_NAME}.git"
  git clone ${USERORIGIN} "/tmp/${PROJECT_NAME}"
#  rsync -av --exclude ".git*" --exclude ".git/" "/tmp/${PROJECT_NAME}" .
  cp -r "/tmp/${PROJECT_NAME}" .
  rm -rf "${PROJECT_NAME}/.git"
  rm -rf "/tmp/${PROJECT_NAME}"
  echo
done