#! /bin/bash
#
#set -x
clear

args=("$@")

scriptname=${0}
scriptBase="$( cd "$( dirname "$scriptname" )";  pwd)"
VAULTPASS_PATH="~/.vault_pass"
echo "${VAULTPASS_PATH}"

function usage() {
  echo "usage: $scriptname ENV HOSTS"
  echo "      where ENV = AWS_DEV | EDE_ALL | EDE_CI | EDE_CIT | EDE_DEV | EDE_SQA | EDE_UAT | local"
  echo "      where HOSTS = all | ci-server | webserver | dbserver "
  return 1
}

function installRoles() {
#ansible-galaxy install <git repository>
  if [ $# -eq 1 ]
  then
    echo "Installing role ${1} for ${ENV} to update of jenkins plugins"
    echo "ansible-galaxy install -f ${1}"
    ansible-galaxy install -f ${1}
  else 
    echo "Please supply role"
    exit 1
  fi
}

function runPlaybook() {
  if [ $# -eq 1 ]
  then
    echo "Running ${ENV} update of jenkins plugins"
    if [[ "${ENV}" == "local" ]]
    then
        echo "ansible-playbook ${1} -i ../environments/${ENV} --extra-vars var_hosts=${HOSTS} --tags updatePlugins"
        ansible-playbook ${1} -i "../environments/${ENV}" --extra-vars "var_hosts=${HOSTS}" --tags updatePlugins
    else
        echo "ansible-playbook ${1} -i ../environments/${ENV} --extra-vars var_hosts=${HOSTS} --vault-password-file ${VAULTPASS_PATH} --tags updatePlugins"
        ansible-playbook ${1} -i "../environments/${ENV}" --extra-vars "var_hosts=${HOSTS}" --vault-password-file ${VAULTPASS_PATH} --tags updatePlugins
    fi
  else 
    echo "Please supply playbook"
    exit 1
  fi
}

if [ $# -lt 2 ]
  then
    ARGC=$#  # Number of args, not counting $0
    echo "Number of args: $ARGC"
    usage
else
  ENV=${args[0]}
  HOSTS=${args[1]}
  playbooks=("configure-ci-server.yml")
  roles=("git+https://bitbucket.org/halfaker/mccfrolejenkins.git")

  for item in "${roles[@]}"
  do
    role=${item}
    installRoles ${role}
  done

  for item in "${playbooks[@]}"
  do
    playBook=${item}
    runPlaybook ${playBook}
  done
  # CONTACT INFO
  CONTACT="Dan McAllister: Daniel.McAllister@Halfaker.com or PII"

  echo ""
fi
