#! /bin/bash
#
#set -x
clear

args=("$@")

scriptname=${0}
scriptBase="$( cd "$( dirname "$scriptname" )";  pwd)"
VAULTPASS_PATH="~/.vault_pass"
USERNAME=""
PASSWD=""
REPO_FILE="elasticsearch-requirements.yml"
ROOT_DIR="$( cd ..;  pwd)"

echo "${VAULTPASS_PATH}"

function usage() {
  echo "usage: $scriptname ENV HOSTS $node_name"
  echo "      where ENV = AWS_DEV | EDE_ALL | EDE_CI | EDE_CIT | EDE_DEV | EDE_SQA | EDE_UAT | MAG_ALL | MAG_CI | MAG_CIT | MAG_DEV | MAG_SQA | MAG_UAT | local"
  echo "      where HOSTS = all | ci-server | webserver | dbserver | lbserver"
  echo "......where $node_name = node name, example node1"
  return 1
}

function runPlaybook() {
  if [ $# -eq 1 ]
  then
    echo "Running ${ENV} install for ${1}"
    if [[ "${ENV}" == "local" ]]
    then
        echo "ansible-playbook ${1} -i ../environments/${ENV} --extra-vars \"var_hosts=${HOSTS}, node_name=${node_name}\""
        ansible-playbook ${1} -i "../environments/${ENV}" --extra-vars "var_hosts=${HOSTS}, node_name=${node_name}"
    else
        echo "ansible-playbook ${1} -i ../environments/${ENV} --extra-vars \"var_hosts=${HOSTS}, node_name=${node_name}\" --vault-password-file ${VAULTPASS_PATH}"
        ansible-playbook ${1} -i "../environments/${ENV}" --extra-vars "var_hosts=${HOSTS}, node_name=${node_name}" --vault-password-file ${VAULTPASS_PATH}
    fi
  else 
    echo "Please supply playbook"
    exit 1
  fi
}

function getCredentials(){
  echo "Collecting credentials to pull source from bitbucket\n"
  echo "Please enter bitbucket username: "
  read USERNAME
  # 8m is the control code to hide characters
  echo "Please enter bitbucket password: "
  read -s PASSWD
}

function installRoles(){
  if [[ ! -e ${REPO_FILE} ]]
  then
    echo "${REPO_FILE} not found, exiting"
    exit 1
  fi
  echo "processing: ${REPO_FILE}"
  REPOS=$(sed -n -e '/^\s*name/p' ${REPO_FILE} | cut -d':' -f 2 | sed 's/^ *//;s/ *$//')
  for repo in ${REPOS} ; do
    PROJECT_NAME="${repo}"
    echo "--> ${PROJECT_NAME}"
    PROJECT_PATH="${ROOT_DIR}/roles/${PROJECT_NAME}"
    echo "--> ${PROJECT_PATH}"
    # Make sure the required directories don't exist
    if [ -e "${PROJECT_PATH}" ] ; then
      echo -e "Role ${PROJECT_NAME} already exists!"
      cd "${ROOT_DIR}/roles"
      rm -rf "${PROJECT_NAME}"
    fi
      # create get the role
    echo -e "INFO: getting role ${PROJECT_NAME}..."
    echo -e "===================================================="
    cd "${ROOT_DIR}/roles"
    mkdir ${PROJECT_NAME}

    USERORIGIN="https://${USERNAME}:${PASSWD}@bitbucket.org/halfaker/${PROJECT_NAME}.git"
    git clone ${USERORIGIN} "/tmp/${PROJECT_NAME}"
    if (( $? == 0 )); then
      rsync -av --exclude ".git*" --exclude ".git/" "/tmp/${PROJECT_NAME}" .
      rm -rf "/tmp/${PROJECT_NAME}"
    else
      echo "problem collecting repo for https://bitbucket.org/halfaker/${PROJECT_NAME}.git"
      echo "please verify you entered the username and password correctly"
      echo "all specified repos are required, exiting"
      exit
    fi
    echo
  done
}

if [ $# -lt 3 ]
  then
    ARGC=$#  # Number of args, not counting $0
    echo "Number of args: $ARGC"
    usage
else
  ENV=${args[0]}
  HOSTS=${args[1]}
  node_name=${args[2]}
  playbooks=("install-elasticsearch.yml")

  echo "get credentials"
  getCredentials
  echo "Install roles from ${REPO_FILE}"
  installRoles ${REPO_FILE}

  for item in "${playbooks[@]}"
  do
    playBook=${item}
    echo
    echo "execute playbook ${playBook} for ${ENV} ${HOSTS}"
    runPlaybook ${playBook}
  done
  # CONTACT INFO
  CONTACT="Dan McAllister: Daniel.McAllister@Halfaker.com or PII"

  echo ""
fi
