import { Injectable } from '@angular/core'
import {Http, Response } from '@angular/http'
import { Observable } from 'rxjs/Rx'
import { environment } from '../../../environments/environment'
import 'rxjs/add/operator/map'
import 'rxjs/add/operator/toPromise'
import { IamPermission } from '../iam-manager/iam-permission'

@Injectable()
export class PermissionsService {

  constructor(private http: Http) {}

  getPermissions(): Observable<IamPermission[]> {

    if (environment.iamPermissionsUrl === '') {
      console.warn("environment.iamPermissionsUrl is not set. Using mock.")
      // mock

      return this.http
              .get('../../assets/config/mock-iam-permissions.json')
              .map(mapPermissions)
              .catch(this.handleError)
    } else {
      return this.http
              .get(environment.iamPermissionsUrl)
              .map(mapPermissions)
              .catch(this.handleError)
    }

  }

  private handleError(error: any): Promise<any> {
    console.error('Error: ' + error)

    error = (error.message || JSON.parse(error._body) || error)
    if (error.error) {
      error = error.error
    }

    return Promise.reject(error)
  }

}

function mapPermissions(response: Response): IamPermission[] {
  return response.json().iam_permissions.map(toPermission);
}

function toPermission(r: any): IamPermission {
  const perm = <IamPermission>({
    title: r.title,
    id: r.id
  });
  return perm;
}
