import { NgModule, ModuleWithProviders } from '@angular/core'
import { CommonModule } from '@angular/common'
import { routing } from './mccf-system.routing'
import { FormsModule, ReactiveFormsModule } from '@angular/forms'
import { EditorModule,
          DataTableModule,
          SharedModule
        } from 'primeng/primeng'

import { AdminMenusComponent } from './admin-menus/admin-menus.component'
import { MainContentComponent } from './main-content/main-content.component';
import { AdminHomeComponent } from './admin-home/admin-home.component';
import { IamManagerComponent } from './iam-manager/iam-manager.component'

@NgModule({
  imports: [
    CommonModule,
    FormsModule,
    routing,
    ReactiveFormsModule,
    EditorModule,
    DataTableModule,
    SharedModule
  ],
  declarations: [
    AdminMenusComponent,
    MainContentComponent,
    AdminHomeComponent,
    IamManagerComponent
  ]
})
export class MccfSystemModule {
  static forRoot(): ModuleWithProviders {
    return {
      ngModule: CommonModule
    }
  }
}
