import {Component, OnDestroy, OnInit} from '@angular/core'

import {MainContent} from '../../core/maincontent/maincontent'
import {MainContentService} from '../../core/maincontent/maincontent.service'
import {TooltipsService} from '../../mccf-common/tooltips/tooltips.service'
import {MccfFormComponent} from '../../mccf-common/mccf-form/mccf-form.component'
import {ErrorService} from '../../core/error-messages/error.service'
import {Subscription} from "rxjs/Subscription";


@Component({
  selector: 'app-main-content',
  templateUrl: './main-content.component.html',
  styleUrls: ['./main-content.component.css'],
  providers: [TooltipsService]
})

export class MainContentComponent extends MccfFormComponent implements OnInit, OnDestroy {
  mainContent: MainContent
  private subscription: Subscription
  private updateSubscription: Subscription

  constructor(private ttService: TooltipsService,
              private error: ErrorService,
              private mcService: MainContentService) {
    super(ttService, error)
  }

  ngOnInit() {
    super.ngOnInit()
    this.subscription = this.mcService.getContent().subscribe(
      res => {
        this.mainContentUpdate(res);
      },
      err => {
        this.error.setErrorCode("", err)
      })
  }

  ngOnDestroy() {
    if (this.subscription) {
      this.subscription.unsubscribe()
    }
    if (this.updateSubscription) {
      this.updateSubscription.unsubscribe()
    }
  }

  mainContentUpdate(data: any) {
    this.mainContent = data
  }

  cancel() {
    this.mainContent = null
    this.ngOnInit()
  }

  update() {
    // this.validate()

    // TODO maincontent form validate
    // if (!this.formInvalid) {
    this.updateSubscription = this.mcService.saveContent(this.mainContent).subscribe(
      res => {
        alert(" mainContent updated.")
      },
      err => {
        this.error.setErrorCode("", err)
      })
    // }
  }

}
