import {Component, ElementRef, OnDestroy, OnInit, QueryList, Renderer, ViewChildren} from '@angular/core'
import {Router} from '@angular/router'
import {Http} from '@angular/http'
import {MenusService} from '../../core/menus/menus.service'
import {Menu} from '../../core/menus/menu'
import {SubMenu} from '../../core/menus/subMenu'
import {ErrorService} from '../../core/error-messages/error.service'
import {TooltipsService} from '../../mccf-common/tooltips/tooltips.service'
import {MccfFormComponent} from '../../mccf-common/mccf-form/mccf-form.component'
// import all modules for building route list
import {routing as MccfEinsuranceModule} from '../../mccf-einsurance/mccf-einsurance.routing'
import {routing as MccfEbillingModule} from '../../mccf-ebilling/mccf-ebilling.routing'
import {routing as MccfEadminModule} from '../../mccf-eadmin/mccf-eadmin.routing'
import {routing as MccfEpharmacyModule} from '../../mccf-epharmacy/mccf-epharmacy.routing'
import {routing as NonMccfModule} from '../../mccf-non-mccf/mccf-non-mccf.routing'
import {routing as MccfCommonModule} from '../../mccf-common/mccf-common.routing'
import {routing as MccfEpaymentModule} from '../../mccf-epayment/mccf-epayment.routing'
import {routing as MccfNpiModule} from '../../mccf-npi/mccf-npi.routing'
import {routing as MccfSystemModule} from '../../mccf-system/mccf-system.routing'
import {Subscription} from "rxjs/Subscription";


@Component({
  selector: 'app-admin-menus',
  templateUrl: './admin-menus.component.html',
  styleUrls: ['./admin-menu.component.css'],
  providers: [TooltipsService]
})
export class AdminMenusComponent extends MccfFormComponent implements OnInit, OnDestroy {
  paths: string[]
  errorMessage = ''
  menus: Menu[]
  formInvalid = false
  @ViewChildren('menuTitle', {read: ElementRef}) menuTitles: QueryList<ElementRef>
  modulePaths: any[] = []
  subscription: Subscription

  constructor(private service: MenusService,
              private error: ErrorService,
              private renderer: Renderer,
              private router: Router,
              private ttService: TooltipsService,
              private http: Http) {
    super(ttService, error)
  }


  ngOnInit() {
    // this.service.getMenus()
    //             .subscribe(this.menuUpdate.bind(this))
    this.subscription = this.service.getMenus().subscribe(
      res => {
        this.menuUpdate(res);
      },
      err => {
        this.error.setErrorCode("", err)
      })
  }

  ngOnDestroy() {
    if (this.subscription) {
      this.subscription.unsubscribe()
    }
  }

  update() {
    this.validate()

    if (!this.formInvalid) {
      this.subscription = this.service.setMenus(this.menus).subscribe(
        res => {
          alert(" Menus updated.")
        },
        err => {
          this.error.setErrorCode("", err)
        })
    }

  }


  cancel() {
    // TODO FIX ME!
    this.service.getMenus()
      .subscribe(this.menuUpdate.bind(this))
    this.formInvalid = false
  }

  onTitleInput() {
    this.formInvalid = false
  }

  validate() {
    // validation: titles required, no duplicate title

    let sortedMenu = this.menus.slice().sort()
    for (let i = 0; i < this.menus.length - 1; i++) {
      if (sortedMenu[i + 1].title === sortedMenu[i].title) {
        this.formInvalid = true
        return
      }
    }

    // sub menus
    for (let i = 0; i < this.menus.length; i++) {
      if (this.menus[i].subMenu) {
        let sortedSub = this.menus[i].subMenu.slice().sort()
        for (let j = 0; j < this.menus[i].subMenu.length - 1; j++) {
          if (sortedSub[j + 1].title === sortedSub[j].title) {
            this.formInvalid = true
            return
          }
        }
      }
    }

    for (let i = 0; i < this.menus.length; i++) {

      if (this.menus[i].title.trim() === '') {
        this.formInvalid = true
        return
      }

      if (this.menus[i].subMenu) {
        for (let j = 0; j < this.menus[i].subMenu.length; j++) {
          if (this.menus[i].subMenu[j].title.trim() === '') {
            this.formInvalid = true
            return
          }
        }
      }
    }
  }

  // *** add module routes here ***
  buildModulePaths() {

    this.modulePaths.push({
      'module': 'MccfEinsuranceModule',
      'data': MccfEinsuranceModule.providers[0]
    })
    this.modulePaths.push({
      'module': 'MccfEbillingModule',
      'data': MccfEbillingModule.providers[0]
    })
    this.modulePaths.push({
      'module': 'MccfEpharmacyModule',
      'data': MccfEpharmacyModule.providers[0]
    })
    this.modulePaths.push({
      'module': 'MccfEadminModule',
      'data': MccfEadminModule.providers[0]
    })
    this.modulePaths.push({
      'module': 'NonMccfModule',
      'data': NonMccfModule.providers[0]
    })
    this.modulePaths.push({
      'module': 'MccfNpiModule',
      'data': MccfNpiModule.providers[0]
    })
    this.modulePaths.push({
      'module': 'MccfCommonModule',
      'data': MccfCommonModule.providers[0]
    })
    this.modulePaths.push({
      'module': 'MccfEpaymentModule',
      'data': MccfEpaymentModule.providers[0]
    })
    this.modulePaths.push({
      'module': 'MccfSystemModule',
      'data': MccfSystemModule.providers[0]
    })
  }

  menuUpdate(data: any) {
    this.menus = data
  }

  addSubMenu(menu: string) {
    for (let i = 0; i < this.menus.length; i++) {
      if (this.menus[i].title === menu) {
        let sub = new SubMenu()

        if (this.menus[i].subMenu === undefined) {
          this.menus[i].subMenu = []
        }
        this.menus[i].subMenu.push(sub)
      }
    }
  }

  deleteSub(menu: Menu, sub: SubMenu) {
    for (let i = 0; i < this.menus.length; i++) {
      if (this.menus[i].title === menu.title) {

        for (let j = 0; j < this.menus[i].subMenu.length; j++) {
          if (this.menus[i].subMenu[j].title === sub.title) {
            this.menus[i].subMenu.splice(j, 1)

            if (this.menus[i].subMenu.length === 0) {
              this.menus[i].subMenu = undefined
              return
            }
          }
        }
      }
    }
  }

  deleteMenu(menu: Menu) {
    for (let i = 0; i < this.menus.length; i++) {
      if (this.menus[i].title === menu.title) {
        this.menus.splice(i, 1)
        return
      }
    }
  }

  addMenu() {
    // TOOD fix c'tor
    let menu = new Menu()
    menu.title = "file me in"
    menu.uri = "http://wwwexample.com"
    this.menus.push(menu);
    setTimeout(() => {
      this.renderer.invokeElementMethod(this.menuTitles.last.nativeElement, 'focus')
    }, 1)
  }

  upMenu(menu: Menu) {
    for (let i = 0; i < this.menus.length; i++) {
      if (this.menus[i].title === menu.title) {
        if (i === 0) {
          return
        }
        let above = this.menus[i - 1]
        this.menus[i - 1] = this.menus[i]
        this.menus[i] = above
        return
      }
    }
  }

  downMenu(menu: Menu) {
    for (let i = 0; i < this.menus.length; i++) {
      if (this.menus[i].title === menu.title) {
        if (i === this.menus.length - 1) {
          return
        }
        let below = this.menus[i + 1]
        this.menus[i + 1] = this.menus[i]
        this.menus[i] = below
        return
      }
    }
  }

  upSubMenu(menu: Menu, sub: SubMenu) {
    for (let i = 0; i < this.menus.length; i++) {
      if (this.menus[i].title === menu.title) {
        for (let j = 0; j < this.menus[i].subMenu.length; j++) {
          if (this.menus[i].subMenu[j].title === sub.title) {
            if (j === 0) {
              return
            }
            let above = this.menus[i].subMenu[j - 1]
            this.menus[i].subMenu[j - 1] = this.menus[i].subMenu[j]
            this.menus[i].subMenu[j] = above
            return
          }
        }
      }
    }
  }

  downSubMenu(menu: Menu, sub: SubMenu) {
    for (let i = 0; i < this.menus.length; i++) {
      if (this.menus[i].title === menu.title) {
        for (let j = 0; j < this.menus[i].subMenu.length; j++) {
          if (this.menus[i].subMenu[j].title === sub.title) {
            if (j === this.menus[i].subMenu.length - 1) {
              return
            }
            let below = this.menus[i].subMenu[j + 1]
            this.menus[i].subMenu[j + 1] = this.menus[i].subMenu[j]
            this.menus[i].subMenu[j] = below
            return
          }
        }
      }
    }
  }
}

function buildPaths(obj: any[], modPaths: any[]): string[] {
  let paths = []

  for (let i = 0; i < obj.length; i++) {

    // get child routes
    if (obj[i].loadChildren) {

      let moduleName = obj[i].loadChildren.split("#")[1]
      let modulePath = obj[i].path
      let modMissing = true

      for (let j = 0; j < modPaths.length; j++) {
        if (modPaths[j].module === moduleName) {
          // exlude system module
          if (modPaths[j].module !== "MccfSystemModule") {

            // extract paths
            let data = modPaths[j].data[0].useValue

            for (let k = 0; k < data.length; k++) {
              paths.push(modulePath + '/' + data[k].path)
            }
          }
          modMissing = false
        }
      }

      if (modMissing) {
        console.error(" Need to add router module to admin-menus: " + moduleName)
      }
    } else {
      if (obj[i].path !== '' && obj[i].path !== '**' && obj[i].path.indexOf(':') < 1) {
        paths.push(obj[i].path)
      }
    }
  }

  return paths
}
