import {ModuleWithProviders, NgModule} from '@angular/core'
import { FormsModule, ReactiveFormsModule } from '@angular/forms'
import {CommonModule} from '@angular/common'
import {MccfCommonModule} from '../mccf-common/mccf-common.module'
import {routing} from './mccf-epayment.routing'
import {LockboxComponent} from './lockbox/lockbox.component'
import {EpaymentHomeComponent} from './epayment-home/epayment-home.component'
import {ClaimResponseComponent} from "./claims-response/claim-response.component"
import {ClaimResponseService} from "./claims-response/claimresponse.service"

@NgModule({
  imports: [CommonModule, routing, MccfCommonModule, FormsModule, ReactiveFormsModule],
  declarations: [LockboxComponent, EpaymentHomeComponent, ClaimResponseComponent],
  exports: [EpaymentHomeComponent, ClaimResponseComponent],
  providers: [ClaimResponseService]
})
export class MccfEpaymentModule {
  static forRoot(): ModuleWithProviders {
    return {
      ngModule: EpaymentHomeComponent
    }
  }
}
