import {
  fakeAsync,
  async,
  tick,
  ComponentFixture,
  getTestBed,
  TestBed
} from '@angular/core/testing'
import * as Axe from 'axe-core'
import { MccfCommonModule } from '../../mccf-common/mccf-common.module'
import { HttpModule } from '@angular/http'
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../karma/karma-helper'
import { RouterTestingModule } from '@angular/router/testing';
import { EpaymentHomeComponent } from './epayment-home.component'
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { ConfigService } from '../../core/config/config.service'
import { ConfigApiService } from '../../core/config/config-api.service'
import { LoggerService } from '../../core/logger/logger.service'
import { AppCommService } from '../../core/app-comm/app-comm.service'
import { ActiveState } from '../../core/activestate/activestate.service'
import { Product } from '../../core/maincontent/product'
import {ErrorService} from "../../core/error-messages/error.service";

describe('EpaymentHomeComponent', () => {
  let component: EpaymentHomeComponent
  let fixture: ComponentFixture<EpaymentHomeComponent>
  let originalTimeout

  beforeEach(async(() => {
    originalTimeout = jasmine.DEFAULT_TIMEOUT_INTERVAL
    jasmine.DEFAULT_TIMEOUT_INTERVAL = 140000

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        HttpModule,
        MccfCommonModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        EpaymentHomeComponent
      ],
      providers: [ActiveState,
        MainContentService,
        ConfigService,
        ConfigApiService,
        LoggerService,
        ErrorService,
        AppCommService]
    })

  }))

  beforeEach(async(() => {
    TestBed.compileComponents()
  }))

  beforeEach(() => {
    fixture = getTestBed().createComponent(EpaymentHomeComponent)
    component = fixture.componentInstance
    component.ngOnInit()
    fixture.detectChanges()
  })

  afterEach(function() {
    jasmine.DEFAULT_TIMEOUT_INTERVAL = originalTimeout
    TestBed.resetTestingModule()
  });

  it('should have no accessibility issues', fakeAsync(() => {
    let res: Axe.AxeResults

    component.product = new Product()
    component.product.name = 'epayment'
    component.product.erevenueUrl = 'www.duckduckgo.com'
    fixture.detectChanges()
    tick()

    // console.error(' @@@@@@@@@@@@@ html='+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions(), (error, result) => {
      this.res = result
      if (error) {
        console.error("AXE-CORE ERROR:" + error)
      }
    })

    tick()
    KarmaHelper.axeViolationLog(this.res)
    expect(this.res.violations.length).toEqual(0)

  }))
})
