import {Injectable} from '@angular/core'
import {Headers, Http, Response} from '@angular/http'
import {Observable} from 'rxjs/Rx'
import {environment} from "../../../environments/environment"
import {ClaimResponse} from "./claimresponse"


@Injectable()
export class ClaimResponseService {
  private productName: string;
  private _claimresponse: Observable<any>
  private _product: Observable<any>
  private headers = new Headers({'X-UserId': 'user01', 'X-Key': '12345'})
  private claimResponseGUID
  private coreAPI
  private MAIN_CONTENT_URL = '../../assets/config/claim-response.json'

  constructor(private http: Http) {
    console.log('ClaimResponseService cTor')
  }

  public getContent(): Observable<ClaimResponse> {
    return this._getContent()
  }

  private _getContent(): Observable<ClaimResponse> {
    if (!this._claimresponse) {
      let url = (environment.use_backend) ? `${environment.coreAPI}/claimresponse` : this.MAIN_CONTENT_URL
      this._claimresponse =
        this.http.get(url, {headers: this.headers})
          .map((res) => this.mapClaimResponse(res))
          .publishReplay(1)
          .refCount()
          .catch((err, caught) => this.handleError(err))
    }
    return this._claimresponse;
  }

  public saveContent(claimResponse: ClaimResponse) {
    return this._saveContent(claimResponse)
  }

  private _saveContent(claimResponse: ClaimResponse): Observable<boolean> {
    return this.http.put(`${environment.coreAPI}/claimresponse/${this.claimResponseGUID}`, claimResponse, {headers: this.headers})
      .map(response => {
        console.log(response)
        return response.text()
      })
      .catch(this.handleError)
  }

  // public getProduct(productName: string): Observable<Product> {
  //   this.productName = productName;
  //   return this.getServices((service) => this._getProduct(service))
  // }
  //
  // private _getProduct(service: any): Observable<Product> {
  //   if (!this._product) {
  //     let url = (environment.use_backend) ? `${service.coreAPI}/claimresponse` : this.MAIN_CONTENT_URL
  //     this._product =
  //       this.http.get(url, {headers: this.headers})
  //         .map((res) => this.mapProduct(res))
  //         .publishReplay(1)
  //         .refCount()
  //         .catch((err, caught) => this.handleError(err))
  //   }
  //   return this._product;
  // }
  //
  // private mapProduct(res: Response): Product {
  //   let result = res.json().items[0].item
  //   let products: Array<Product> = result["product"]
  //
  //   for (let i = 0; i < products.length; i++) {
  //     if (this.productName === products[i].name.toLowerCase()) {
  //
  //       let prod: Product = new Product()
  //       prod.name = products[i].name
  //       prod.erevenueUrl = products[i].erevenueUrl
  //
  //       let links = products[i].links
  //       if (links) {
  //         for (let j = 0; j < links.length; j++) {
  //           let link: ProductLink = new ProductLink()
  //           link.name = links[j].name
  //           link.uri = links[j].uri
  //           prod.links.push(link)
  //         }
  //       }
  //       return prod
  //     }
  //   }
  //   return null
  // }
  //
  private mapClaimResponse(res: Response): ClaimResponse {
    // let item0 = res.json().items[0]
    // this.claimResponseGUID = item0.id
    // let result = item0.item
    // let claimResponse = new ClaimResponse()
    // let products: Array<Product> = response["product"]
    //
    // for (let i = 0; i < products.length; i++) {
    //   let prod: Product = new Product()
    //
    //   prod.name = products[i].name
    //   prod.erevenueUrl = products[i].erevenueUrl
    //
    //   let links = products[i].links
    //   if (links) {
    //     for (let j = 0; j < links.length; j++) {
    //       let link: ProductLink = new ProductLink()
    //       link.name = links[j].name
    //       link.uri = links[j].uri
    //       prod.links.push(link)
    //     }
    //   }
    //   claimResponse.product.push(prod)
    // }
    //
    // claimResponse.phone = response["phone"]
    // claimResponse.emailText = response["emailText"]
    // claimResponse.emailValue = response["emailValue"]
    // claimResponse.helpContent = response["helpContent"]

    return res.json()
  }

  handleError(err: any) {
    console.log('sever error:', err);  // debug
    if (err instanceof Response) {
      return Observable.throw(this.getErrorMessage(err));
    }
    return Observable.throw(err || 'backend server error');
  }

  getErrorMessage(err) {
    let error = err.json();
    if (typeof error === 'object' && error.resourceType === 'OperationOutcome' && error.issue && error.issue[0]) {
      return {
        errorCode: 504, // VA-FHIR-Server error
        message: error.issue[0].diagnostics || 'VA-FHIR-Server Error - unknown'
      }
    } else {
      return err.error || 'unknown server error'
    }
  }

}
