import {Component, OnDestroy, OnInit} from '@angular/core'
import {FormControl, FormGroup, Validators} from '@angular/forms'

import {TooltipsService} from '../../mccf-common/tooltips/tooltips.service'
import {MccfFormComponent} from '../../mccf-common/mccf-form/mccf-form.component'
import {ErrorService} from '../../core/error-messages/error.service'
import {Subscription} from "rxjs/Subscription"
import {ClaimResponseService} from "./claimresponse.service"
import {ClaimResponse} from "./claimresponse"

@Component({
  selector: 'app-epayment-claim-response',
  templateUrl: './claim-response.component.html',
  styleUrls: ['./claim-response.component.css'],
  providers: [TooltipsService, ClaimResponseService]
})

export class ClaimResponseComponent extends MccfFormComponent implements OnInit, OnDestroy {
  claimResponse: ClaimResponse
  subscription: Subscription
  updateSubscription: Subscription
  page = 'search'
  private chartData
  private revenueByEFT
  private revenueBy3rdParty

  // form controls
  formGroup: FormGroup

  constructor(private ttService: TooltipsService,
              private error: ErrorService,
              private claimsResponseService: ClaimResponseService) {
    super(ttService, error)
  }

  ngOnInit() {
    this.formGroup = new FormGroup({
    })
  }

  ngOnDestroy() {
    if (this.subscription) {
      this.subscription.unsubscribe()
    }
    if (this.updateSubscription) {
      this.updateSubscription.unsubscribe()
    }
  }

  claimResponseUpdate(data: any) {
    this.claimResponse = data

    this.revenueByEFT = Array.apply(null, new Array(9)).map(() => 0)
    this.revenueByEFT.push(data.entry[0].resource.payment.amount.value)

    this.revenueBy3rdParty = Array.apply(null, new Array(9)).map(() => 0)
    this.revenueBy3rdParty.push(data.entry[0].resource.item[0].adjudication[0].amount.value)


    this.chartData = {
      labels: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October'],
      datasets: [
        {
          label: 'Revenue by EFT',
          backgroundColor: '#42A5F5',
          borderColor: '#1E88E5',
          data: this.revenueByEFT
        },
        {
          label: '3rd Party Revenue',
          backgroundColor: '#9CCC65',
          borderColor: '#7CB342',
          data: this.revenueBy3rdParty
        }
      ]
    }

  }

  cancel() {
    this.claimResponse = null
    this.ngOnInit()
  }

  update() {
    // this.validate()

    // TODO maincontent form validate
    // if (!this.formInvalid) {
    this.updateSubscription = this.claimsResponseService.saveContent(this.claimResponse).subscribe(
      res => {
        alert(" claimResponse updated.")
      },
      err => {
        this.error.setErrorCode("", err)
      })
    // }
  }


  public onSubmit({value, valid}: { value: any, valid: boolean }) {
    this.page = 'loading'

    this.subscription = this.claimsResponseService.getContent().subscribe(
      res => {
        this.claimResponseUpdate(res);
        this.page = 'results'
      },
      err => {
        this.error.setErrorCode("", err)
        this.page = 'error'
      })

  }


}
