import { async,
        ComponentFixture,
        TestBed } from "@angular/core/testing"
import * as Axe from "axe-core"
import { HttpModule} from "@angular/http"
import { ReactiveFormsModule } from "@angular/forms"
import { KarmaHelper } from "../../../../karma/karma-helper"


import {ClaimResponseComponent} from "./claim-response.component"
import {ClaimResponseService} from "./claimresponse.service"
import {ErrorService} from "../../core/error-messages/error.service"

describe('ClaimResponseComponent', () => {
  let component: ClaimResponseComponent
  let fixture: ComponentFixture<ClaimResponseComponent>

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [HttpModule,
        ReactiveFormsModule],
      declarations: [ ClaimResponseComponent ],
      providers: [
        ClaimResponseService,
        ErrorService
      ]
    })
    .compileComponents()
  }))

  beforeEach(() => {
    fixture = TestBed.createComponent(ClaimResponseComponent)
    component = fixture.componentInstance
    fixture.detectChanges()
  })

  it('search page should have no accessibility issues', ((done) => {

    Axe.run(document, KarmaHelper.axeOptions()).then((result) => {
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error) => {
        console.error("AXE-CORE ERROR:" + error)
    })
  }))

  it('results page should have no accessibility issues', ((done) => {
    component.page = 'results'
    fixture.detectChanges()

    // console.error(' @@@@@@@@@@@@@ html=' + document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions()).then((result) => {
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error) => {
        console.error("AXE-CORE ERROR:" + error)
    })
  }))

  it('loading page should have no accessibility issues', ((done) => {
    component.page = 'loading'
    fixture.detectChanges()

    Axe.run(document, KarmaHelper.axeOptions()).then((result) => {
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error) => {
        console.error("AXE-CORE ERROR:" + error)
    })
  }))

  it('error page should have no accessibility issues', ((done) => {
    component.page = 'error'
    fixture.detectChanges()

    Axe.run(document, KarmaHelper.axeOptions()).then((result) => {
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error) => {
        console.error("AXE-CORE ERROR:" + error)
    })
  }))

})
