import { Injectable } from '@angular/core'
import { Http, Response } from '@angular/http'
import { config } from '../config'
import { Observable } from 'rxjs/Rx'
import 'rxjs/add/operator/map'
import 'rxjs/add/operator/toPromise'

import { Provider } from './provider'
import { Patient } from './patient'
import { Resource } from './resource'
import { Identifier } from './identifier'
import { Extension } from './extension'
import { Telecom } from './telecom'
import { Address } from './address'
import { Role } from './role'
import { Use } from './use'
import { Item } from './item'
import { Exposure } from './exposure'
import { Facility } from './facility'
import { TypeCoding } from './type-coding'

@Injectable()
export class FhirDataService {

  constructor(private http: Http) { }

  getResources(type: string, id: string): Observable<Resource[]> {
    if (type === 'tf') {
      return this.http.get(config.PatientTestUrl + type + '/' + id).map(mapTreatmentFacilities)
    } else if (type === 'prv') {
      return this.http.get(config.PatientTestUrl + type + '/' + id).map(mapPractitioners)
    } else {
      return null
    }
  }

  getPatients(id: string): Observable<Patient[]> {
    return this.http.get(config.PatientTestUrl + 'hmppt/' + id).map(mapPatients)
  }

  getProviders(): Observable<Provider[]> {
    return this.http.get(config.PatientTestUrl + 'lp1/').map(mapProviders)
  }

}

function mapPatients(response: Response): Patient[] {
  let r = response.json()
  // console.log(' JSON result ========== ' + JSON.stringify(r))

  let patients: Array<Patient> = []

  let p = new Patient()

  if (r.hasOwnProperty('401')) {
    p.returnCode = '401'
    patients.push(p)
    return patients
  }

  let data = r['data']
  p.totalItems = data.totalItems

  for (let i = 0; i < p.totalItems; i++) {
    let itm: Item = new Item()

    itm.admissionUid = data.items[i].admissionUid
    itm.birthDate = data.items[i].birthDate
    itm.briefId = data.items[i].briefId
    itm.cwadf = data.items[i].cwadf
    itm.familyName = data.items[i].familyName
    itm.fullName = data.items[i].fullName
    itm.genderCode = data.items[i].genderCode
    itm.genderName = data.items[i].genderName
    itm.givenNames = data.items[i].givenNames
    itm.inpatientLocation = data.items[i].inpatientLocation
    itm.lastUpdateTime = data.items[i].lastUpdateTime
    itm.localId = data.items[i].localId
    itm.lrdfn = data.items[i].lrdfn
    itm.pid = data.items[i].pid
    itm.sensitive = data.items[i].sensitive
    itm.serviceConnected = data.items[i].serviceConnected
    itm.shortInpatientLocation = data.items[i].shortInpatientLocation
    itm.specialty = data.items[i].specialty
    itm.specialtyService = data.items[i].specialtyService
    itm.ssn = data.items[i].ssn
    itm.stampTime = data.items[i].stampTime
    itm.uid = data.items[i].uid
    itm.veteran = data.items[i].veteran

    if (data.items[i].teamInfo) {
      itm.teamInfo.associateProviderName = data.items[i].teamInfo.associateProvider.name

      itm.teamInfo.attendingProviderAnalogPager = data.items[i].teamInfo.attendingProvider.analogPager
      itm.teamInfo.attendingProviderDigitalPager = data.items[i].teamInfo.attendingProvider.digitalPager
      itm.teamInfo.attendingProviderName = data.items[i].teamInfo.attendingProvider.name
      itm.teamInfo.attendingProviderOfficePhone = data.items[i].teamInfo.attendingProvider.officePhone
      itm.teamInfo.attendingProviderUid = data.items[i].teamInfo.attendingProvider.uid

      itm.teamInfo.inpatientProviderAnalogPager = data.items[i].teamInfo.inpatientProvider.analogPager
      itm.teamInfo.inpatientProviderDigitalPager = data.items[i].teamInfo.inpatientProvider.digitalPager
      itm.teamInfo.inpatientProviderName = data.items[i].teamInfo.inpatientProvider.name
      itm.teamInfo.inpatientProviderOfficePhone = data.items[i].teamInfo.inpatientProvider.officePhone
      itm.teamInfo.inpatientProviderUid = data.items[i].teamInfo.inpatientProvider.uid

      itm.teamInfo.mhCoordinatorMhPosition = data.items[i].teamInfo.mhCoordinator.mhPosition
      itm.teamInfo.mhCoordinatorMhTeam = data.items[i].teamInfo.mhCoordinator.mhTeam
      itm.teamInfo.mhCoordinatorName = data.items[i].teamInfo.mhCoordinator.name

      itm.teamInfo.primaryProviderName = data.items[i].teamInfo.primaryProvider.name
      itm.teamInfo.teamName = data.items[i].teamInfo.team.name
      itm.teamInfo.text = data.items[i].teamInfo.text
    }

    if (data.items[i].exposure) {
      for (let j = 0; j < data.items[i].exposure.length; j++) {
        let exp: Exposure = new Exposure()
        exp.name = data.items[i].exposure[j].name
        exp.uid = data.items[i].exposure[j].uid
        itm.exposures.push(exp)
      }
    }

    if (data.items[i].facility) {
      for (let k = 0; k < data.items[i].facility.length; k++) {
        let fac: Facility = new Facility()
        fac.code = data.items[i].facility[k].code
        fac.latestDate = data.items[i].facility[k].latestDate
        fac.name = data.items[i].facility[k].name
        itm.facility.push(fac)
      }
    }

    p.items.push(itm)
  }

  patients.push(p)
  return patients
}

function mapProviders(response: Response): Provider[] {
  let r = response.json()
  console.log(' lp1 JSON result ======== ' + JSON.stringify(r))

  let providers: Array<Provider> = []

  if (r.hasOwnProperty('401')) {
    let p = new Provider()
    p.returnCode = '401'
    providers.push(p)
    return providers
  }

  let keys = Object.keys(r)
  for (let i = 0; i < keys.length; i++) {
    let p = new Provider()
    p.fullName = r[keys[i]]
    p.id = keys[i]
    providers.push(p)
  }

  return providers
}

function mapPractitioners(response: Response): Resource[] {
  let r = response.json()
  // console.log(' prv JSON result ======== ' + JSON.stringify(r))

  let resources: Array<Resource> = []

  let p = new Resource()

  if (r.hasOwnProperty('401')) {
    p.returnCode = '401'
    resources.push(p)
    return resources
  }

  p.name = r.name
  p.gender = r.gender
  p.resourceType = r.resourceType
  p.active = r.active
  p.birthDate = r.birthDate

  let identifier: Identifier = new Identifier()
  identifier.system = r['identifier[0].system']
  identifier.value = r['identifier[0].value']
  identifier.use = r['identifier[0].use']
  p.identifier.push(identifier)

  let identifier2: Identifier = new Identifier()
  identifier2.system = r['identifier[1].system']
  identifier2.value = r['identifier[1].value']
  identifier2.use = r['identifier[1].use']
  p.identifier.push(identifier2)

  let telecom: Telecom = new Telecom()
  telecom.use = new Use()
  telecom.system = r['telecom[0].system']
  telecom.value = r['telecom[0].value']
  telecom.use.system = r['telecom[0].use.system']
  telecom.use.value = r['telecom[0].use.value']
  p.telecom.push(telecom)

  let telecom2: Telecom = new Telecom()
  telecom2.use = new Use()
  telecom2.system = r['telecom[1].system']
  telecom2.value = r['telecom[1].value']
  telecom2.use.system = r['telecom[1].use.system']
  telecom2.use.value = r['telecom[1].use.value']
  p.telecom.push(telecom2)

  let telecom3: Telecom = new Telecom()
  telecom3.use = new Use()
  telecom3.system = r['telecom[2].system']
  telecom3.value = r['telecom[2].value']
  telecom3.use.system = r['telecom[2].use.system']
  telecom3.use.value = r['telecom[2].use.value']
  p.telecom.push(telecom3)

  let telecom4: Telecom = new Telecom()
  telecom4.use = new Use()
  telecom4.system = r['telecom[3].system']
  telecom4.value = r['telecom[3].value']
  telecom4.use.system = r['telecom[3].use.system']
  telecom4.use.value = r['telecom[3].use.value']
  p.telecom.push(telecom4)

  let telecom5: Telecom = new Telecom()
  telecom5.use = new Use()
  telecom5.system = r['telecom[4].system']
  telecom5.value = r['telecom[4].value']
  telecom5.use.system = r['telecom[4].use.system']
  telecom5.use.value = r['telecom[4].use.value']
  p.telecom.push(telecom5)

  let telecom6: Telecom = new Telecom()
  telecom6.use = new Use()
  telecom6.system = r['telecom[5].system']
  telecom6.value = r['telecom[5].value']
  telecom6.use.system = r['telecom[5].use.system']
  telecom6.use.value = r['telecom[5].use.value']
  p.telecom.push(telecom6)

  let telecom7: Telecom = new Telecom()
  telecom7.use = new Use()
  telecom7.system = r['telecom[6].system']
  telecom7.value = r['telecom[6].value']
  telecom7.use.system = r['telecom[6].use.system']
  telecom7.use.value = r['telecom[6].use.value']
  p.telecom.push(telecom7)

  let telecom8: Telecom = new Telecom()
  telecom8.use = new Use()
  telecom8.system = r['telecom[7].system']
  telecom8.value = r['telecom[7].value']
  telecom8.use.system = r['telecom[7].use.system']
  telecom8.use.value = r['telecom[7].use.value']
  p.telecom.push(telecom8)

  let address: Address = new Address()
  address.use = new Use()

  address.city = r['address[0].city']
  address.type = r['address[0].type']
  address.line1 = r['address[0].line[0]']
  address.line2 = r['address[0].line[1]']
  address.line3 = r['address[0].line[2]']
  address.use.value = r['address[0].use.value']
  address.use.system = r['address[0].use.system']
  p.address.push(address)

  p.extension = new Extension()

  p.extension.active = r['address[0].extension.active']
  p.extension.degree = r['extension.degree']
  p.extension.vistaHealthcareService = r['extension.vistaHealthcareService']
  p.extension.referenceOrganization.push(r['extension.reference.organization[0]'])

  p.qualificationIssuer.push(r['qualification[0].issuer'])

  let role: Role = new Role()
  role.code = r['role[0].code']
  role.specialty = r['role[0].specialty']
  role.periodStart = r['role[0].period.start']
  role.periodEnd = r['role[0].period.end']
  p.role.push(role)

  resources.push(p)
  return resources
}

function mapTreatmentFacilities(response: Response): Resource[] {
  let r = response.json()
  // console.log(' tf JSON result ======== ' + JSON.stringify(r))

  let resources: Array<Resource> = []

  let p = new Resource()

  if (r.hasOwnProperty('401')) {
    p.returnCode = '401'
    resources.push(p)
    return resources
  }

  p.resourceType = r.resourceType

  let identifier: Identifier = new Identifier()
  identifier.system = r['identifier[0].system']
  identifier.value = r['identifier[0].value']
  identifier.use = r['identifier[0].use']
  p.identifier.push(identifier)

  let identifier2: Identifier = new Identifier()
  identifier2.system = r['identifier[1].system']
  identifier2.value = r['identifier[1].value']
  identifier2.use = r['identifier[1].use']
  p.identifier.push(identifier2)

  p.active = r.active

  p.typeCoding = new TypeCoding()
  p.typeCoding.code = r['type.coding.code']
  p.typeCoding.system = r['type.coding.system']
  p.typeCoding.text = r['type.coding.text']

  p.name = r.name
  p.nameExtensionOfficial = r['name.extension.official']

  let telecom: Telecom = new Telecom()
  telecom.use = new Use()
  telecom.system = r['telecom[0].system']
  telecom.value = r['telecom[0].value']
  telecom.use.system = r['telecom[0].use.system']
  telecom.use.value = r['telecom[0].use.value']
  telecom.rank = r['telecom[0].rank']
  p.telecom.push(telecom)

  let address: Address = new Address()
  address.use = new Use()
  address.use.value = r['address[0].use.value']
  address.use.system = r['address[0].use.system']
  address.type = r['address[0].type']
  address.city = r['address[0].city']
  address.state = r['address[0].state']
  address.line1 = r['address[0].line[0]']
  address.line2 = r['address[0].line[1]']
  address.postalCode = r['address[0].postalCode']
  p.address.push(address)

  let address1: Address = new Address()
  address1.use = new Use()
  address1.use.value = r['address[1].use.value']
  address1.use.system = r['address[1].use.system']
  address1.type = r['address[1].type']
  address1.line1 = r['address[1].line[0]']
  address1.line2 = r['address[1].line[1]']
  address1.city = r['address[1].city']
  address1.state = r['address[1].state']
  p.address.push(address1)

  resources.push(p)
  return resources
}
