import { TestBed, inject, fakeAsync, async, tick } from '@angular/core/testing'
import { MockBackend, MockConnection } from '@angular/http/testing'
import { Http, BaseRequestOptions, Response, ResponseOptions, RequestMethod } from '@angular/http'
import { ErrorService } from '../../../core/error-messages/error.service'

import { FhirDataService } from './fhir-data.service'
import { Provider } from './provider'
import { Patient } from './patient'
import { Resource } from './resource'
import { Identifier } from './identifier'
import { Extension } from './extension'
import { Telecom } from './telecom'
import { Address } from './address'
import { Role } from './role'
import { Use } from './use'
import { Item } from './item'
import { Exposure } from './exposure'
import { Facility } from './facility'
import { TypeCoding } from './type-coding'


describe('FhirService', () => {
  let service: FhirDataService
  let backend: MockBackend

  beforeEach(() => {
    TestBed.configureTestingModule({
      providers: [FhirDataService,
                  MockBackend,
                  ErrorService,
                  BaseRequestOptions,
                  Resource,
                  Provider,
                  Patient,
                  Identifier,
                  Extension,
                  Telecom,
                  Address,
                  Role,
                  Use,
                  Item,Exposure,Facility,TypeCoding,
                  {
                    provide: Http,
                    useFactory: function(mockBackend, defaultOptions) {
                      return new Http(mockBackend, defaultOptions)
                    },
                    deps: [MockBackend, BaseRequestOptions]
                  }
                ]
    })
  })

  beforeEach(inject([FhirDataService, MockBackend], function(fhirService, mockBackend) {
    service = fhirService
    backend = mockBackend
  }));

  afterEach(function() {
    TestBed.resetTestingModule()
  });

  it('getResources treatment facility should get data', async () => {

    backend.connections.subscribe(function(connection: MockConnection) {

      let options = new ResponseOptions(
        { body: {

            "resourceType":"Organization",
            "identifier[0].system":"http://URL/fhir/sid/fileman/file/4",
            "identifier[0].use":"usual",
            "identifier[0].value":"59",
            "identifier[1].use":"usual",
            "identifier[1].value":"",
            "active":"true",
            "type.coding.system":"http://hl7.org/fhir/ValueSet/organization-type",
            "type.coding.code":"institution",
            "type.coding.text":"VA Treating Facility",
            "name":"SAN DIEGO HCS (664)",
            "name.extension.official":"",
            "telecom[0].system":"phone",
            "telecom[0].value":"",
            "telecom[0].use.system":"http://URL/fhir/code-system/telecom-use",
            "telecom[0].use.value":"work",
            "telecom[0].rank":"50",
            "address[0].use.system":"http://URL/fhir/code-system/address-use",
            "address[0].use.value":"physical address",
            "address[0].type":"both",
            "address[0].line[0]":"<no address provided>"

                }
        }
      )
      connection.mockRespond(new Response(options));
    })

    let resource: Array<Resource>

    await service.getResources('tf','1').subscribe(res => {
       resource = res
    })

    expect(resource.length).toEqual(1)
    expect(resource[0].resourceType).toEqual('Organization')
  })


  it('getResources practitioner should get data', async () => {

    backend.connections.subscribe(function(connection: MockConnection) {

      let options = new ResponseOptions(
        { body: {

            "resourceType":"prac",
            "identifier[0].system":"http://URL/fhir/sid/fileman/file/4",
            "identifier[0].use":"usual",
            "identifier[0].value":"59",
            "identifier[1].use":"usual",
            "identifier[1].value":"",
            "active":"true",
            "type.coding.system":"http://hl7.org/fhir/ValueSet/organization-type",
            "type.coding.code":"institution",
            "type.coding.text":"VA Treating Facility",
            "name":"SAN DIEGO HCS (664)",
            "name.extension.official":"",
            "telecom[0].system":"phone",
            "telecom[0].value":"",
            "telecom[0].use.system":"http://URL/fhir/code-system/telecom-use",
            "telecom[0].use.value":"work",
            "telecom[0].rank":"50",
            "address[0].use.system":"http://URL/fhir/code-system/address-use",
            "address[0].use.value":"physical address",
            "address[0].type":"both",
            "address[0].line[0]":"<no address provided>"

                }
        }
      )
      connection.mockRespond(new Response(options));
    })

    let resource: Array<Resource>

    await service.getResources('prv','1').subscribe(res => {
       resource = res
    })

    expect(resource.length).toEqual(1)
    expect(resource[0].resourceType).toEqual('prac')
  })



})
