import {Injectable} from '@angular/core'
import {Http, Response} from '@angular/http'
import {Observable} from 'rxjs/Rx'
import {SiteParam} from './site-param'

export interface SiteParamInt {
  params: string,
  id: string
}

@Injectable()
export class SiteParametersService {

  constructor(private http: Http) {
  }


  private handleError(err: any) {
    console.log('sever error:', err);  // debug
    if (err instanceof Response) {
      return Observable.throw(err.json().error || 'backend server error');
    }
    return Observable.throw(err || 'backend server error');
  }

  getSiteParams(): Observable<SiteParam[]> {

    // this.http.get(`${service.eInsuranceAPI}/siteparams`).map(this.mapSiteParam).catch((err, caught) => this.handleError(err))
    return null
  }

  mapSiteParam(response: Response): SiteParam[] {
    let siteparams: any = response.json();
    let s: any = siteparams.SiteParameters[0]
    let siteParams: Array<SiteParam> = []

    let arr = Object.keys(s).map(function (data) {
      let sp = new SiteParam()
      sp.id = data
      sp.name = s[data]
      siteParams.push(sp)
    })

    return siteParams
  }
}
