import {async, inject, TestBed} from '@angular/core/testing'
import {BaseRequestOptions, Connection, Http, Response, ResponseOptions} from '@angular/http';
import {MockBackend, MockConnection} from '@angular/http/testing';
import {SiteParametersService} from './site-parameters.service';

describe('SiteParametersService', () => {
  let siteParametersService: SiteParametersService
  let backend: MockBackend;
  let lastConnection: Connection;

  beforeEach(() => {
    TestBed.configureTestingModule({
      providers: [SiteParametersService,
        MockBackend,
        BaseRequestOptions,
        {
          provide: Http,
          useFactory: function (mockBackend, defaultOptions) {
            return new Http(mockBackend, defaultOptions);
          },
          deps: [MockBackend, BaseRequestOptions]
        }
      ]
    })
  })

  beforeEach(inject([SiteParametersService, MockBackend], function (SiteParametersService, mockBackend) {
    siteParametersService = SiteParametersService
    backend = mockBackend
    backend.connections.subscribe((connection: any) => lastConnection = connection)
  }))

  it('should construct', async(inject(
    [SiteParametersService, MockBackend], (service, mockBackend) => {

      expect(service).toBeDefined();
  })));

  afterEach(function () {
    TestBed.resetTestingModule();
  })

})
