import { NgModule, ModuleWithProviders } from '@angular/core'
import { CommonModule } from '@angular/common'
import { routing } from './mccf-einsurance.routing'
import { FormsModule, ReactiveFormsModule } from '@angular/forms'
import { EinsuranceHomeComponent } from './einsurance-home/einsurance-home.component'
import { MccfCommonModule } from '../mccf-common/mccf-common.module'
import { IcbwebComponent } from './icbweb/icbweb.component'
import { EinsuranceComponent } from './einsurance/einsurance.component'

@NgModule({
  imports: [CommonModule, routing, MccfCommonModule, FormsModule, ReactiveFormsModule],
  declarations: [EinsuranceHomeComponent, IcbwebComponent, EinsuranceComponent],
  exports: [EinsuranceHomeComponent]
})
export class MccfEinsuranceModule {
  static forRoot(): ModuleWithProviders {
    return {
      ngModule: EinsuranceHomeComponent
    }
  }
}
