import {
  fakeAsync,
  async,
  tick,
  ComponentFixture,
  getTestBed,
  TestBed
} from '@angular/core/testing'
import * as Axe from 'axe-core'
import { HttpModule } from '@angular/http'
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../karma/karma-helper'
import { RouterTestingModule } from '@angular/router/testing';

import { IcbwebComponent } from './icbweb.component'

import { ActiveState } from '../../core/activestate/activestate.service'
import { MccfCommonModule } from '../../mccf-common/mccf-common.module'
import { LinkComponent } from '../../mccf-common/link/link.component'
import { Product } from '../../core/maincontent/product'
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { ConfigService } from '../../core/config/config.service'
import { ConfigApiService } from '../../core/config/config-api.service'
import { LoggerService } from '../../core/logger/logger.service'
import { AppCommService } from '../../core/app-comm/app-comm.service'
import { AppModule } from '../../app.module'
import {ErrorService} from "../../core/error-messages/error.service";

describe('IcbwebComponent', () => {
  let component: IcbwebComponent
  let fixture: ComponentFixture<IcbwebComponent>
  let originalTimeout

  beforeEach(async(() => {
    originalTimeout = jasmine.DEFAULT_TIMEOUT_INTERVAL
    jasmine.DEFAULT_TIMEOUT_INTERVAL = 140000

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        MccfCommonModule,
        HttpModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        IcbwebComponent
      ],
      providers: [ActiveState,
        MainContentService,
        ConfigService,
        ConfigApiService,
        LoggerService,
        ErrorService,
        AppCommService]
    })

  }))

  beforeEach(async(() => {
    TestBed.compileComponents()
  }))

  beforeEach(() => {
    fixture = getTestBed().createComponent(IcbwebComponent)
    component = fixture.componentInstance
    component.ngOnInit()
    fixture.detectChanges()
  })

  afterEach(function() {
    jasmine.DEFAULT_TIMEOUT_INTERVAL = originalTimeout
    TestBed.resetTestingModule();
  });

  it('should have no accessibility issues', ((done) => {
    // console.error(' @@@@@@@@@@@@@ html='+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions()).then((result) => {
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error) => {
      console.error('AXE-CORE ERROR:' + error)
    })
  }))


})
