import {Component, Inject, OnDestroy, OnInit} from '@angular/core';
import {SiteParametersService, SiteParamInt} from '../service/einsurance/site-parameters.service'
import {SiteParam} from '../service/einsurance/site-param'
import {FormControl, FormGroup, Validators} from '@angular/forms'
import {FhirService} from '../service/fhir/fhir.service'
import {Record} from '../service/fhir/record'
import {Subscription} from "rxjs/Subscription";

@Component({
  selector: 'app-einsurance',
  templateUrl: './einsurance.component.html',
  styleUrls: ['./einsurance.component.css'],
  providers: [SiteParametersService, FhirService]
})
export class EinsuranceComponent implements OnInit, OnDestroy {
  fhirService: FhirService
  isLoading = true
  page = 'load'
  siteParams: Array<SiteParam> = []
  siteParamsStr = ''
  records: Array<Record>
  recordId: string
  subscription: Subscription

  // form controls
  siteParamsGroup: FormGroup

  constructor(private service: SiteParametersService, private fs: FhirService) {
    this.fhirService = fs
  }

  ngOnInit() {
    this.siteParamsGroup = new FormGroup({
      params: new FormControl('', Validators.required),
      id: new FormControl('', Validators.required)
    })

    // this.subscription = this.service.getSiteParams().subscribe(
    //   res => {
    //     this.isLoading = false
    //     this.siteParams = res
    //   },
    //   err => {
    //     // TODO toast, log or dialog
    //     this.isLoading = false
    //   }
    // )

    // this.service.getSiteParams()
    //   .then(res => {
    //     this.isLoading = false
    //     this.siteParams = res
    //   })
    //   .catch(err => {
    //     this.isLoading = false
    //   })

    this.page = 'search'

  }

  ngOnDestroy() {
    if (this.subscription) {
      this.subscription.unsubscribe()
    }
  }

  public onSubmit({value, valid}: { value: SiteParamInt, valid: boolean }) {
    this.isLoading = true
    let sarr: any = value
    this.siteParamsStr = sarr.params.join(';')
    this.recordId = sarr.id

    this.fhirService.getRecord(this.siteParamsStr, this.recordId)
      .then(res => {
        this.isLoading = false
        this.records = res
        this.page = 'record'
      })
      .catch(err => {
        this.isLoading = false
        this.page = 'notfound'
      })

  }

  public back() {
    this.page = 'search'
  }

}
