import {
  fakeAsync,
  async,
  tick,
  ComponentFixture,
  getTestBed,
  TestBed
} from '@angular/core/testing'
import * as Axe from 'axe-core'
import { ErrorService } from '../../core/error-messages/error.service'
import { HttpModule } from '@angular/http'
import { MccfCommonModule } from '../../mccf-common/mccf-common.module'
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../karma/karma-helper'
import { RouterTestingModule } from '@angular/router/testing'

import { EinsuranceComponent } from './einsurance.component'
import {SiteParametersService} from '../service/einsurance/site-parameters.service'

describe('EinsuranceComponent', () => {
  let component: EinsuranceComponent
  let fixture: ComponentFixture<EinsuranceComponent>
  let originalTimeout

  beforeEach(async(() => {
    originalTimeout = jasmine.DEFAULT_TIMEOUT_INTERVAL
    jasmine.DEFAULT_TIMEOUT_INTERVAL = 140000

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        HttpModule,
        MccfCommonModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        EinsuranceComponent
      ],
      providers: [ErrorService,
        SiteParametersService]
    })

  }))

  beforeEach(async(() => {
    TestBed.compileComponents()
  }))

  beforeEach(() => {
    fixture = getTestBed().createComponent(EinsuranceComponent)
    component = fixture.componentInstance
    component.ngOnInit()
    fixture.detectChanges()
  })

  afterEach(function() {
    jasmine.DEFAULT_TIMEOUT_INTERVAL = originalTimeout
    TestBed.resetTestingModule();
  });

  it('search page should have no accessibility issues', ((done) => {
    component.isLoading = false
    component.page = 'search'
    fixture.detectChanges()

    // console.error(' @@@@@@@@@@@@@ html='+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions()).then((result) => {
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error) => {
      console.error('AXE-CORE ERROR:' + error)
    })
  }))

  it('record page should have no accessibility issues', ((done) => {
    component.isLoading = false
    component.page = 'record'
    fixture.detectChanges()

    // console.error(' @@@@@@@@@@@@@ html='+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions()).then((result) => {
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error) => {
      console.error('AXE-CORE ERROR:' + error)
    })
  }))


})
