import {Injectable} from '@angular/core'
import {Headers, Http} from '@angular/http'
import {Observable} from 'rxjs/Rx'
import {environment} from "../../../environments/environment"

@Injectable()
export class TooltipsService {
  private _tooltips: Observable<any>
  private headers = new Headers({'X-UserId': 'user01', 'X-Key': '12345'})
  private TOOLTIPS_URL = '../../assets/config/tooltips.json'

  constructor(private http: Http) {
    console.log('ToolTipService cTor')
  }

  public clearCache(): any {
    // super.clearCache();
    this._tooltips = null;
  }

  public getTooltips(): Observable<any> {
    return this._getToolTips()
  }

  private _getToolTips(): Observable<any> {
    if (!this._tooltips) {
      let url = (environment.use_backend) ? `${environment.coreAPI}/tooltips` : this.TOOLTIPS_URL
      this._tooltips =
        this.http.get(url, {headers: this.headers})
          .map((res) => res.json().items[0].item)
          .publishReplay(1)
          .refCount()
          .catch((err, caught) => this.handleError(err))
    }
    return this._tooltips;
  }

  /**
   * slightly different usage here, this is a lookup from the client.
   * @param {Array<any>} tooltips
   * @param title
   * @returns {string}
   */
  public mapTooltips(tooltips: Array<any>, title): string {
    let tooltip = "Tooltip Not Found"

    if (tooltips.hasOwnProperty(title)) {
      tooltip = tooltips[title]
    }
    return tooltip
  }

  handleError(err: any) {
    console.log('sever error:', err);  // debug
    if (err instanceof Response) {
      return Observable.throw(this.getErrorMessage(err));
    }
    return Observable.throw(err || 'backend server error');
  }

  getErrorMessage(err) {
    let error = err.json();
    if (typeof error === 'object' && error.resourceType === 'OperationOutcome' && error.issue && error.issue[0]) {
      return {
        errorCode: 504, // VA-FHIR-Server error
        message: error.issue[0].diagnostics || 'VA-FHIR-Server Error - unknown'
      }
    } else {
      return err.error || 'unknown server error'
    }
  }

}
