import {inject, TestBed} from '@angular/core/testing'
import {MockBackend, MockConnection} from '@angular/http/testing'
import {BaseRequestOptions, Http, Response, ResponseOptions} from '@angular/http'
import {TooltipsService} from './tooltips.service'

describe('TooltipsService', () => {
  let service: TooltipsService
  let backend: MockBackend

  beforeEach(() => {
    TestBed.configureTestingModule({
      providers: [TooltipsService,
        MockBackend,
        BaseRequestOptions,
        {
          provide: Http,
          useFactory: function (mockBackend, defaultOptions) {
            return new Http(mockBackend, defaultOptions)
          },
          deps: [MockBackend, BaseRequestOptions]
        }
      ]
    })
  })

  beforeEach(inject([TooltipsService, MockBackend], function (TooltipsService, mockBackend) {
    service = TooltipsService;
    backend = mockBackend;
  }));

  afterEach(function () {
    TestBed.resetTestingModule();
  });

  it('tooltip should lookup data', function () {

    backend.connections.subscribe(function (connection: MockConnection) {

      let options = new ResponseOptions(
        {
          body: {
            "items": [
              {
                "collection": "tooltips",
                "id": "default_tooltips",
                "item": {
                  "search": "Enter search term.",
                  "contact-search": "Click to search contacts.",
                  "site-wide-search": "Click to search site.",
                  "phone": "Enter a phone number.",
                  "rte": "Rich text editor",
                  "emailtitle": "Enter email title.",
                  "email": "Enter email address.",
                  "erevenueurl": "Enter eRevenue URL.",
                  "cancel": "Click cancel to discard changes.",
                  "save": "Click to save changes."
                }
              }
            ],
            "total": 1
          }
        }
      )
      connection.mockRespond(new Response(options));
    })

    service.getTooltips().subscribe(res => {
      expect(res).toBeDefined()
      expect(service.mapTooltips(res, 'search')).toBe('Enter search term.')
    })

  })

})
