import {Component, OnInit} from '@angular/core'

import {TooltipsService} from '../../mccf-common/tooltips/tooltips.service'
import {Subscription} from "rxjs/Subscription";
import {ErrorService} from "../../core/error-messages/error.service";

@Component({
  selector: 'app-mccf-form',
  templateUrl: './mccf-form.component.html',
  styleUrls: ['./mccf-form.component.css']
})
export class MccfFormComponent implements OnInit {

  private tooltipsSubscription: Subscription
  private tooltips: Array<Object>

  constructor(private tooltipService: TooltipsService,
              private myError: ErrorService) {}

  ngOnInit() {
    let _this = this
    setTimeout(function(){
      // tooltips is low priority, let resources finish generating page
      _this.tooltipsSubscription = _this.tooltipService.getTooltips().subscribe(
        res => {
          _this.tooltips = res;
        },
        err => {
          _this.myError.setErrorCode("", err)
        }
      )
    }, 1600)

  }

  tooltip(type: string, elem: any) {
    if (!elem.target.attributes['title']) {
      elem.target.setAttribute('title', '')
    }

    if (elem.target.attributes['title'].value === "") {
      elem.target.attributes['title'].value = this.tooltipService.mapTooltips(this.tooltips, type);
    }

  }

}
