import {
  inject,
  TestBed,
  ComponentFixture,
  getTestBed,
  async,
  fakeAsync,
  tick,
  discardPeriodicTasks
} from '@angular/core/testing'
import { HttpModule } from "@angular/http"
import * as Axe from 'axe-core'
import { KarmaHelper } from '../../../../karma/karma-helper'

import { ConfigApiService } from '../../core/config/config-api.service'
import { ConfigService } from '../../core/config/config.service'
import { LoggerService } from '../../core/logger/logger.service'
import { AppCommService } from '../../core/app-comm/app-comm.service'
import { LinkComponent } from './link.component'
import {ErrorService} from "../../core/error-messages/error.service";

describe('LinkComponent', () => {
  let component: LinkComponent
  let fixture: ComponentFixture<LinkComponent>

  beforeEach(async(() => {

    TestBed.configureTestingModule({
      imports: [HttpModule],
      declarations: [LinkComponent],
      providers: [LoggerService,
                  ConfigService,
                  ConfigApiService,
                  AppCommService,
                  ErrorService
      ]
    }).compileComponents()


  }))

  afterEach(function() {
    TestBed.resetTestingModule()
  })

  it('Link page should have no accessibility issues', fakeAsync(() => {
    let res: Axe.AxeResults
    let fixt: ComponentFixture<LinkComponent> = getTestBed()
      .createComponent(LinkComponent)
    let comp = fixt.componentInstance

    comp.ngOnInit()
    fixt.detectChanges()
    comp.seconds = 1
    fixt.detectChanges()

    Axe.run(document, KarmaHelper.axeOptions(), (error, result) => {
      this.res = result
      if (error) {
        console.error(error)
      }
    })

    tick()
    KarmaHelper.axeViolationLog(this.res)
    tick()
    expect(this.res.violations.length).toEqual(0)
    tick()
    discardPeriodicTasks()
  }))

  it('Link seconds should be greater than 0', fakeAsync(() => {
    let fixt: ComponentFixture<LinkComponent> = getTestBed()
      .createComponent(LinkComponent)
    let comp = fixt.componentInstance
    comp.ngOnInit()
    comp.secondsConfigured = 9
    comp.href = "http://www.google.com"
    comp.localDomains = ["0", "1"]
    comp.click()
    fixt.detectChanges()

    expect(comp.seconds).toBeGreaterThan(0)
    tick(500)
    discardPeriodicTasks()

  }))

})
