import { fakeAsync,
        async,
        tick,
        ComponentFixture,
        TestBed } from '@angular/core/testing'
import * as Axe from 'axe-core'
import { HttpModule} from "@angular/http"
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../karma/karma-helper'

import { ContactComponent } from './contact.component';

describe('ContactComponent', () => {
  let component: ContactComponent;
  let fixture: ComponentFixture<ContactComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ ContactComponent ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(ContactComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should have no accessibility issues', ((done) => {

    Axe.run(document, KarmaHelper.axeOptions()).then((result)=>{
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error)=>{
        console.error("AXE-CORE ERROR:"+error)
    })
  }))

});
