import {Injectable} from '@angular/core'
import {Headers, Http, Response} from '@angular/http'
import {Observable} from 'rxjs/Rx'
import {environment} from "../../../environments/environment"

@Injectable()
export class SeedService {
  private coreAPI
  private headers = new Headers({'X-UserId': 'user01', 'X-Key': '12345'})

  public seeds = [
    {
      collection: 'menus',
      jsonURL: '../../assets/config/menus.json'
    }, {
      collection: 'tooltips',
      jsonURL: '../../assets/config/tooltips.json'
    }, {
      collection: 'maincontent',
      jsonURL: '../../assets/config/maincontent.json'
    }
  ]

  constructor(private http: Http) {
    console.log('Seed Service cTor')
  }

  public getSeed(collection: string, jsonURL: string): Observable<any> {
    if (environment.use_backend) {
      return this._getSeed(collection, jsonURL)
    } else {
      return Observable.of('No seeding done - backend not in use.')
    }
  }

  _getSeed(collection: string, jsonURL: string): Observable<any> {
    this.coreAPI = environment.coreAPI
    return this.http.get(`${environment.coreAPI}/${collection}`, {headers: this.headers})
      .flatMap((res) => this.setSeed(res, collection, jsonURL))
      .catch((err, caught) => this.handleError(err))
  }

  private setSeed(res: Response, collection: string, jsonURL: string): Observable<string> {
    if (res && res.json().total < 1
    ) {
      return this.http.get(jsonURL)
        .map((_res: Response) => {
          return _res.json().items[0].item;
        })
        .flatMap((menus) =>
          this.http.put(`${this.coreAPI}/${collection}/default_guid`, menus, {headers: this.headers})
            .map(response => {
              console.log(response)
              return response.text()
            })
            .catch(err => this.handleError(err))
        )
        .catch(err => this.handleError(err))
    } else {
      return Observable.of('Success - menu already seeded')
    }
  }

  handleError(err: any) {
    console.log('sever error:', err);  // debug
    if (err instanceof Response) {
      return Observable.throw(this.getErrorMessage(err));
    }
    return Observable.throw(err || 'backend server error');
  }

  getErrorMessage(err) {
    let error = err.json();
    if (typeof error === 'object' && error.resourceType === 'OperationOutcome' && error.issue && error.issue[0]) {
      return {
        errorCode: 504, // VA-FHIR-Server error
        message: error.issue[0].diagnostics || 'VA-FHIR-Server Error - unknown'
      }
    } else {
      return err.error || 'unknown server error'
    }
  }
}
