import {async, inject, TestBed} from '@angular/core/testing';
import {MockBackend, MockConnection} from '@angular/http/testing';
import {BaseRequestOptions, Connection, Http, Response, ResponseOptions} from '@angular/http';

import {SeedService} from './seed.service';
import {environment} from "../../../environments/environment";

describe('SeedsService', function () {
  let seedService: SeedService;
  let backend: MockBackend;
  let lastConnection: Connection;

  beforeEach(function () {

    TestBed.configureTestingModule({
      providers: [
        SeedService,
        MockBackend,
        BaseRequestOptions,
        {
          provide: Http,
          useFactory: function (mockBackend, defaultOptions) {
            return new Http(mockBackend, defaultOptions);
          },
          deps: [MockBackend, BaseRequestOptions]
        }
      ]
    });

  });

  beforeEach(inject([SeedService, MockBackend], function (SeedsService, mockBackend) {
    seedService = SeedsService;
    backend = mockBackend;
    backend.connections.subscribe((connection: any) => lastConnection = connection);
  }));

  it('should construct', async(inject(
    [SeedService, MockBackend], (service, mockBackend) => {

      expect(service).toBeDefined();
    })));

  it('should query current service url', () => {
    environment.use_backend = true;
    seedService.getSeed(seedService.seeds[0].collection, seedService.seeds[0].jsonURL);
    expect(lastConnection).toBeDefined('no http service connection at all?');
  });


  it('should get data', function (done) {

    backend.connections.subscribe(function (connection: MockConnection) {

      let options = new ResponseOptions({
        body: {
          "items": [
            {
              "collection": "tooltips",
              "id": "default_tooltips",
              "item": {
                "search": "Enter search term.",
                "contact-search": "Click to search contacts.",
                "site-wide-search": "Click to search site.",
                "phone": "Enter a phone number.",
                "rte": "Rich text editor",
                "emailtitle": "Enter email title.",
                "email": "Enter email address.",
                "erevenueurl": "Enter eRevenue URL.",
                "cancel": "Click cancel to discard changes.",
                "save": "Click to save changes."
              }
            }
          ],
          "total": 1
        }
      });
      connection.mockRespond(new Response(options));
    });

    seedService.getSeed(seedService.seeds[0].collection, seedService.seeds[0].jsonURL ).subscribe(function (response) {

        // TODO - seeding is a short term solution, until we have a groups, id in place
        //expect(response).toEqual('No seeding done - backend not in use.');
        expect(response).toEqual('Success - menu already seeded');
      },
      function (e) {
        fail(e);
      }
    );

    done();
  });

  afterEach(function () {
    TestBed.resetTestingModule();
  });


});
