import { ElementRef, HostListener, Component, Input, OnInit } from '@angular/core'
import { Router } from '@angular/router'
import { SearchApiService } from './search-api.service'
import { TooltipsService } from '../../mccf-common/tooltips/tooltips.service'
import { MccfFormComponent } from '../../mccf-common/mccf-form/mccf-form.component'
import {ErrorService} from "../error-messages/error.service";

enum FilterBy {
  terms,
  content
}

@Component({
  selector: 'app-search',
  templateUrl: './search.component.html',
  styleUrls: ['./search.component.css']
})
export class SearchComponent extends MccfFormComponent implements OnInit {
  results: Array<any>
  filterText: string
  filterTimeout: any

  @Input() filterBy: string
  @Input() filterProperty: string
  @Input() datasource: string
  @Input() ariaLabel: string

  constructor(
    private ttService: TooltipsService,
    private router: Router,
    private eRef: ElementRef,
    public searchApiService: SearchApiService,
    private error: ErrorService) {
      super(ttService, error)
      this.results = []
      this.filterText = ''
  }

  filterResults(): Promise<Array<any>> {
    return new Promise((resolve, reject) => {
      // console.log(`filterResults|datasource:${this.datasource}|filterProperty:${this.filterProperty}|filterBy:${this.filterBy}|text:${this.filterText}`)
      this.searchApiService
        .filter({ datasource: this.datasource, filterProperty: this.filterProperty, filterBy: this.filterBy, text: this.filterText })
        .subscribe(results => {
          // console.log(`~filterResults|${results.items}`)
          resolve(results.items)
        })
    })
  }

  updateHighlight($event, item) {
    item.className = 'usa-button usa-button-outline ' + ($event.type === 'mouseover' ? 'usa-button-hover' : '')
  }

  @HostListener('document:mouseup', ['$event'])
  async externalMouseUp(event: MouseEvent) {
    if (this.eRef.nativeElement.contains(event.target) === false) {
      // console.log(`document:mouseup`)
      this.results = []
    }
  }

  async search() {
    const params = { queryParams: { q: this.filterText, type: this.datasource } }
    console.log(`params:${JSON.stringify(params)}`)
    this.router.navigate(['/results/results'], params)
    this.filterText = ''
  }

  async select(item) {
    console.log(`CLICKED ON: ${JSON.stringify(item)}`)
    // this.search()
    this.filterText = item[this.filterProperty]
    this.results = []
  }

  async applyFilter() {
    const results = await this.filterResults()
    this.results = results
  }

  contactBoxKeyUp($event: any) {
    clearTimeout(this.filterTimeout)
    this.filterTimeout = setTimeout(async () => {
      if (this.filterText.length === 0) {
        this.results = []
        return
      }
      await this.applyFilter()
    }, 250)
  }

  ngOnInit() {
    super.ngOnInit()
    // this.searchApiService
    //   .tokenizationTerms(this.datasource, this.filterProperty)
    //   .subscribe(results => {
    //     console.log(results)
    //   })
  }
}
