import { fakeAsync, async, tick, ComponentFixture, TestBed } from '@angular/core/testing'
import { FormsModule } from '@angular/forms'
import * as Axe from 'axe-core'
import { KarmaHelper } from '../../../../karma/karma-helper'

import { LocalConfig } from '../config/local-config'
import { HttpModule, Http, BaseRequestOptions } from '@angular/http'
import { MockBackend } from '@angular/http/testing'
import { RouterTestingModule } from '@angular/router/testing'

import { SearchComponent } from './search.component'
import { ConfigApiService } from '../../core/config/config-api.service'
import { ConfigService } from '../../core/config/config.service'
import { SearchApiService } from '../../core/search/search-api.service'
import { SearchApiServiceStub } from './search-api.service.stub'
import {TooltipsService} from "../../mccf-common/tooltips/tooltips.service";
import {ErrorService} from "../error-messages/error.service";

describe('SearchComponent', () => {
  let component: SearchComponent
  let fixture: ComponentFixture<SearchComponent>

  beforeEach(async(() => {
    LocalConfig.DataProvider = "memory"
    TestBed.configureTestingModule({
      imports: [
        FormsModule,
        HttpModule,
        RouterTestingModule,
      ],
      declarations: [
        SearchComponent
      ],
      providers: [{
        provide: Http, useFactory: (backend, options) => {
          return new Http(backend, options)
        },
        deps: [MockBackend, BaseRequestOptions]
      },
      { provide: SearchApiService, useClass: SearchApiServiceStub },
        ErrorService,
        MockBackend,
        TooltipsService,
        BaseRequestOptions,
        ConfigService,
        ConfigApiService]
    })
      .compileComponents()
  }))

  beforeEach(() => {
    fixture = TestBed.createComponent(SearchComponent)
    component = fixture.componentInstance
    fixture.detectChanges()
  })

  it('should have no accessibility issues', fakeAsync(() => {
    let res: Axe.AxeResults
    fixture.detectChanges()
    tick()
    // console.error(' @@@@@@@@@@@@@ html='+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions(), (error, result) => {
      this.res = result
      if (error) {
        console.error("AXE-CORE ERROR:" + error)
      }
    })

    tick()
    KarmaHelper.axeViolationLog(this.res)
    expect(this.res.violations.length).toEqual(0)

  }))

  // xit('expects rendered list via tokenization', (done) => {
  //   inject([SearchApiService], (async (searchApiService: SearchApiService) => {
  //     component.datasource = 'content'
  //     component.filterProperty = 'text'
  //     component.filterBy = 'terms'
  //
  //     searchApiService.tokenizationTerms(component.datasource, component.filterProperty).subscribe(async terms => {
  //       let sample_key = terms[0]
  //
  //       component.filterText = sample_key[0]
  //
  //       await component.applyFilter()
  //
  //       fixture.detectChanges()
  //
  //       let de: DebugElement = fixture.debugElement.query(By.css('.va-dropdown-panel > ul'))
  //       expect(de).not.toBeNull()
  //
  //       de.children.forEach(p => {
  //         expect(p.nativeElement.textContent.trim()[0]).toEqual(component.filterText)
  //       })
  //
  //       done()
  //     })
  //   }))()
  // })
  //
  // xit('expects rendered list', (inject([SearchApiService], async (searchApiService: SearchApiService) => {
  //   const sample = (await searchApiService._dump('contacts'))[10]
  //
  //   component.datasource = 'contacts'
  //   component.filterProperty = 'name'
  //
  //   component.filterText = sample[component.filterProperty][0]
  //
  //   await component.applyFilter()
  //
  //   fixture.detectChanges()
  //
  //   let de: DebugElement = fixture.debugElement.query(By.css('.va-dropdown-panel > ul'))
  //   expect(de).not.toBeNull()
  //
  //   de.children.forEach(p => {
  //     expect(p.nativeElement.textContent.trim()[0]).toEqual(component.filterText)
  //   })
  // })))
  //
  // xit('expects rendered subset', (done) => {
  //   async(inject([SearchApiService], ((searchApiService: SearchApiService) => {
  //     searchApiService.stats('contacts', 'name', Aggregate.FirstLetter)
  //       .subscribe(async stats => {
  //         component.datasource = 'contacts'
  //         component.filterProperty = 'name'
  //
  //         //+ use letter with largest count so subsequent query size will be less than or equal to
  //         component.filterText = Object.keys(stats)[0]
  //
  //         await component.applyFilter()
  //
  //         const initialResults = component.results.slice(0)
  //
  //         expect(initialResults.length).toBeGreaterThan(0)
  //
  //         const letter = initialResults[0][component.filterProperty][1]
  //         component.filterText += letter
  //
  //         await component.applyFilter()
  //         const secondResults = component.results.slice(0)
  //
  //         expect(secondResults.length).toBeLessThanOrEqual(initialResults.length)
  //
  //         for (const needsToExist of secondResults) {
  //           expect(initialResults).toContain(needsToExist)
  //         }
  //
  //         fixture.detectChanges()
  //
  //         let de: DebugElement = fixture.debugElement.query(By.css('.va-dropdown-panel > ul'))
  //         expect(de).not.toBeNull()
  //
  //         de.children.forEach(p => {
  //           expect(p.nativeElement.textContent.trim().substring(0, 2)).toEqual(component.filterText)
  //         })
  //
  //         done()
  //       })
  //   }))())
  // })
  //
  //
  //
  // xit('expects search result via tokenization', (done) => {
  //   inject([SearchApiService], async (searchApiService: SearchApiService) => {
  //     component.datasource = 'content'
  //     component.filterProperty = 'text'
  //     component.filterBy = 'terms'
  //
  //     searchApiService.tokenizationTerms(component.datasource, component.filterProperty).subscribe(async terms => {
  //       let sample_key = terms[0]
  //
  //       component.filterText = sample_key[0]
  //
  //       await component.applyFilter()
  //
  //       expect(component.results.length).toBeGreaterThan(0)
  //
  //       expect(component.results[0][component.filterProperty][0]).toEqual(component.filterText)
  //
  //       component.results.forEach(p => {
  //         expect(p[component.filterProperty][0]).toEqual(sample_key[0])
  //       })
  //
  //       done()
  //     })
  //   })()
  // })
  //
  // xit('expects search results', inject([SearchApiService], async (searchApiService: SearchApiService) => {
  //   const sample = (await searchApiService._dump('contacts'))[10]
  //
  //   component.datasource = 'contacts'
  //   component.filterProperty = 'name'
  //
  //   component.filterText = sample[component.filterProperty][0]
  //
  //   await component.applyFilter()
  //
  //   expect(component.results.length).toBeGreaterThan(0)
  //
  //   expect(component.results[0][component.filterProperty][0]).toEqual(component.filterText)
  // }))

  // it('expects Error (missing datasource)', inject([SearchApiService], async (searchApiService: SearchApiService) => {
  //   const contacts = (await searchApiService._dump('contacts'))[10]
  //
  //   component.filterProperty = 'name'
  //   component.filterText = contacts[component.filterProperty][0]
  //
  //   try {
  //     await component.filterResults()
  //     expect(0).toEqual(1)
  //   }
  //   catch (ex) {
  //     expect(ex).toEqual('datasource is required')
  //     return
  //   }
  //   expect(0).toEqual(1)
  // }))
  //
  // it('expects Error (missing filterProperty)', inject([SearchApiService], async (searchApiService: SearchApiService) => {
  //   const contacts = (await searchApiService._dump('contacts'))[10]
  //
  //   component.datasource = 'asdfasdf'
  //   component.filterText = contacts.name[0]
  //
  //   try {
  //     await component.filterResults()
  //     expect(0).toEqual(1)
  //   }
  //   catch (ex) {
  //     expect(ex).toEqual('filterProperty is required')
  //     return
  //   }
  //   expect(0).toEqual(1)
  // }))

  // xit('expects search results of subset', (done) => {
  //   inject([SearchApiService], async (searchApiService: SearchApiService) => {
  //     searchApiService.stats('contacts', 'name', Aggregate.FirstLetter)
  //       .subscribe(async stats => {
  //         component.datasource = 'contacts'
  //         component.filterProperty = 'name'
  //
  //         //+ use letter with largest count so subsequent query size will be less than or equal to
  //         component.filterText = Object.keys(stats)[0]
  //
  //         await component.applyFilter()
  //
  //         const initialResults = component.results.slice(0)
  //
  //         expect(initialResults.length).toBeGreaterThan(0)
  //
  //         const letter = initialResults[0][component.filterProperty][1]
  //         component.filterText += letter
  //
  //         await component.applyFilter()
  //         const secondResults = component.results.slice(0)
  //
  //         expect(secondResults.length).toBeLessThanOrEqual(initialResults.length)
  //
  //         for (const needsToExist of secondResults) {
  //           expect(initialResults).toContain(needsToExist)
  //         }
  //         done()
  //       })
  //   })()
  // })

})
